/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.jakarta.ws.rs.core.GenericType;
import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Namespace;
import java.util.List;
import java.util.stream.Stream;

public class NamespaceApi
extends AbstractApi {
    public NamespaceApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Namespace> getNamespaces() throws GitLabApiException {
        return this.getNamespaces(this.getDefaultPerPage()).all();
    }

    public List<Namespace> getNamespaces(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "namespaces");
        return response.readEntity(new GenericType<List<Namespace>>(){});
    }

    public Pager<Namespace> getNamespaces(int itemsPerPage) throws GitLabApiException {
        return new Pager<Namespace>(this, Namespace.class, itemsPerPage, null, "namespaces");
    }

    public Stream<Namespace> getNamespacesStream() throws GitLabApiException {
        return this.getNamespaces(this.getDefaultPerPage()).stream();
    }

    public List<Namespace> findNamespaces(String query) throws GitLabApiException {
        return this.findNamespaces(query, this.getDefaultPerPage()).all();
    }

    public List<Namespace> findNamespaces(String query, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", query, true).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, formData.asMap(), "namespaces");
        return response.readEntity(new GenericType<List<Namespace>>(){});
    }

    public Pager<Namespace> findNamespaces(String query, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("search", query, true);
        return new Pager<Namespace>(this, Namespace.class, itemsPerPage, formData.asMap(), "namespaces");
    }

    public Stream<Namespace> findNamespacesStream(String query) throws GitLabApiException {
        return this.findNamespaces(query, this.getDefaultPerPage()).stream();
    }
}

