/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.websso;

import java.util.Set;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.liberty.paos.Request;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.util.SOAPHelper;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import sqsaml.org.springframework.security.saml.context.SAMLMessageContext;
import sqsaml.org.springframework.security.saml.storage.SAMLMessageStorage;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileImpl;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileOptions;

public class WebSSOProfileECPImpl
extends WebSSOProfileImpl {
    @Override
    public String getProfileIdentifier() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp";
    }

    @Override
    public void sendAuthenticationRequest(SAMLMessageContext context, WebSSOProfileOptions options) throws SAMLException, MetadataProviderException, MessageEncodingException {
        SPSSODescriptor spDescriptor = (SPSSODescriptor)context.getLocalEntityRoleMetadata();
        AssertionConsumerService assertionConsumer = this.getAssertionConsumerService(options, null, spDescriptor);
        AuthnRequest authRequest = this.getAuthnRequest(context, options, assertionConsumer, null);
        context.setCommunicationProfileId(this.getProfileIdentifier());
        context.setOutboundMessage(this.getEnvelope());
        context.setOutboundSAMLMessage(authRequest);
        SOAPHelper.addHeaderBlock(context, this.getPAOSRequest(assertionConsumer));
        SOAPHelper.addHeaderBlock(context, this.getECPRequest(context, options));
        this.sendMessage(context, spDescriptor.isAuthnRequestsSigned(), "urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
        HTTPOutTransport outTransport = (HTTPOutTransport)context.getOutboundMessageTransport();
        outTransport.setHeader("Content-Type", "application/vnd.paos+xml");
        SAMLMessageStorage messageStorage = context.getMessageStorage();
        if (messageStorage != null) {
            messageStorage.storeMessage(authRequest.getID(), authRequest);
        }
    }

    @Override
    protected boolean isEndpointSupported(AssertionConsumerService endpoint) {
        return "urn:oasis:names:tc:SAML:2.0:bindings:PAOS".equals(endpoint.getBinding());
    }

    @Override
    protected boolean isEndpointSupported(SingleSignOnService endpoint) {
        return false;
    }

    protected Request getPAOSRequest(AssertionConsumerService assertionConsumer) {
        SAMLObjectBuilder paosRequestBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Request.DEFAULT_ELEMENT_NAME);
        Request paosRequest = (Request)paosRequestBuilder.buildObject();
        paosRequest.setSOAP11Actor("http://schemas.xmlsoap.org/soap/actor/next");
        paosRequest.setSOAP11MustUnderstand(true);
        paosRequest.setResponseConsumerURL(assertionConsumer.getLocation());
        paosRequest.setService("urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
        return paosRequest;
    }

    protected org.opensaml.saml2.ecp.Request getECPRequest(SAMLMessageContext context, WebSSOProfileOptions options) {
        SAMLObjectBuilder ecpRequestBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(org.opensaml.saml2.ecp.Request.DEFAULT_ELEMENT_NAME);
        org.opensaml.saml2.ecp.Request ecpRequest = (org.opensaml.saml2.ecp.Request)ecpRequestBuilder.buildObject();
        ecpRequest.setSOAP11Actor("http://schemas.xmlsoap.org/soap/actor/next");
        ecpRequest.setSOAP11MustUnderstand(true);
        ecpRequest.setPassive(options.getPassive());
        ecpRequest.setProviderName(options.getProviderName());
        ecpRequest.setIssuer(this.getIssuer(context.getLocalEntityId()));
        Set<String> idpEntityNames = options.getAllowedIDPs();
        if (options.isIncludeScoping().booleanValue() && idpEntityNames != null) {
            ecpRequest.setIDPList(this.buildIDPList(idpEntityNames, null));
        }
        return ecpRequest;
    }

    protected Envelope getEnvelope() {
        SOAPObjectBuilder envelopeBuilder = (SOAPObjectBuilder)this.builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        return (Envelope)envelopeBuilder.buildObject();
    }
}

