/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.trust.httpclient;

import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import sqsaml.org.apache.commons.httpclient.protocol.Protocol;
import sqsaml.org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import sqsaml.org.springframework.security.saml.key.KeyManager;
import sqsaml.org.springframework.security.saml.trust.httpclient.TLSProtocolSocketFactory;

public class TLSProtocolConfigurer
implements InitializingBean {
    private String protocolName = "https";
    private int protocolPort = 443;
    private KeyManager keyManager;
    private String sslHostnameVerification = "default";
    private Set<String> trustedKeys;

    public void afterPropertiesSet() throws Exception {
        TLSProtocolSocketFactory socketFactory = new TLSProtocolSocketFactory(this.keyManager, this.trustedKeys, this.sslHostnameVerification);
        Protocol p = new Protocol(this.protocolName, (ProtocolSocketFactory)socketFactory, this.protocolPort);
        Protocol.registerProtocol(this.protocolName, p);
    }

    @Autowired
    public void setKeyManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public void setSslHostnameVerification(String sslHostnameVerification) {
        this.sslHostnameVerification = sslHostnameVerification;
    }

    public void setTrustedKeys(Set<String> trustedKeys) {
        this.trustedKeys = trustedKeys;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public void setProtocolPort(int protocolPort) {
        this.protocolPort = protocolPort;
    }
}

