/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.trust;

import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sqsaml.org.springframework.security.saml.trust.UntrustedCertificateException;

public class X509TrustManager
implements javax.net.ssl.X509TrustManager {
    private final Logger log = LoggerFactory.getLogger(X509TrustManager.class);
    protected CriteriaSet criteriaSet;
    protected TrustEngine<X509Credential> trustEngine;

    public X509TrustManager(CriteriaSet criteriaSet, TrustEngine<X509Credential> trustEngine) {
        this.criteriaSet = criteriaSet;
        this.trustEngine = trustEngine;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.log.debug("Client trust verification, always passes");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (x509Certificates == null || x509Certificates.length == 0) {
            throw new IllegalArgumentException("Null or empty certificates list");
        }
        BasicX509Credential credential = new BasicX509Credential();
        X509Certificate x509Certificate = x509Certificates[0];
        credential.setEntityCertificate(x509Certificate);
        credential.setEntityCertificateChain(Arrays.asList(x509Certificates));
        credential.setUsageType(UsageType.UNSPECIFIED);
        EntityIDCriteria entityIDCriteria = this.criteriaSet.get(EntityIDCriteria.class);
        if (entityIDCriteria != null) {
            credential.setEntityId(entityIDCriteria.getEntityID());
        }
        try {
            this.log.debug("Checking server trust");
            if (!this.trustEngine.validate(credential, this.criteriaSet)) {
                Principal issuerDN = x509Certificate.getIssuerDN();
                Principal subjectDN = x509Certificate.getSubjectDN();
                StringBuilder sb = new StringBuilder(120);
                sb.append("Peer SSL/TLS certificate '").append(subjectDN).append("' ");
                sb.append("issued by '").append(issuerDN).append("' ");
                sb.append("is not trusted, add the certificate or it's CA to your trust store and optionally update tlsKey in extended metadata with the certificate's alias");
                throw new UntrustedCertificateException(sb.toString(), x509Certificates);
            }
            this.log.debug("Server certificate trust verified");
        }
        catch (SecurityException e) {
            throw new CertificateException("Error validating certificate", e);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

