/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.trust;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.codec.Hex;

public class UntrustedCertificateException
extends CertificateException {
    private X509Certificate[] x509Certificates;

    public UntrustedCertificateException(String msg, X509Certificate[] x509Certificates) {
        super(msg);
        this.x509Certificates = x509Certificates;
    }

    public X509Certificate[] getX509Certificates() {
        return this.x509Certificates;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(150);
        sb.append(super.getMessage());
        if (this.x509Certificates != null && this.x509Certificates.length > 0) {
            sb.append("\n\nFollow certificates (in PEM format) presented by the peer. Content between being/end certificate (including) can be stored in a file and imported using keytool, e.g. 'keytool -importcert -file cert.cer -alias certAlias -keystore keystore.jks'). Make sure the presented certificates are issued by your trusted CA before adding them to the keystore.\n\n");
            for (X509Certificate cert : this.x509Certificates) {
                sb.append("Subject: ").append(cert.getSubjectDN()).append("\n");
                sb.append("Serial number: ").append(cert.getSerialNumber()).append("\n");
                UntrustedCertificateException.appendThumbPrint(cert, sb);
                sb.append("\n");
                UntrustedCertificateException.appendCertificate(cert, sb);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private static void appendThumbPrint(X509Certificate x509Certificate, StringBuilder sb) {
        sb.append("Thumbprint SHA-1: ");
        UntrustedCertificateException.appendThumbPrint(x509Certificate, "SHA-1", sb);
        sb.append("\n");
        sb.append("Thumbprint MD5: ");
        UntrustedCertificateException.appendThumbPrint(x509Certificate, "MD5", sb);
        sb.append("\n");
    }

    private static void appendThumbPrint(X509Certificate cert, String hash, StringBuilder sb) {
        try {
            MessageDigest md = MessageDigest.getInstance(hash);
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            char[] encode = Hex.encode((byte[])digest);
            UntrustedCertificateException.appendHexSpace(encode, sb);
        }
        catch (NoSuchAlgorithmException e) {
            sb.append("Error calculating thumbprint: " + e.getMessage());
        }
        catch (CertificateEncodingException e) {
            sb.append("Error calculating thumbprint: " + e.getMessage());
        }
    }

    private static void appendHexSpace(char[] data, StringBuilder sb) {
        for (int i = 1; i <= data.length; ++i) {
            sb.append(data[i - 1]);
            if (i % 2 != 0 || i == data.length) continue;
            sb.append(":");
        }
    }

    private static void appendCertificate(X509Certificate x509Certificate, StringBuilder sb) {
        sb.append("-----BEGIN CERTIFICATE-----\n");
        try {
            int j;
            String certificate = new String(Base64.encode((byte[])x509Certificate.getEncoded()));
            int i = 0;
            while ((j = i + 76) < certificate.length()) {
                sb.append(certificate.substring(i, j)).append("\n");
                i = j;
            }
            sb.append(certificate.substring(i)).append("\n");
        }
        catch (CertificateEncodingException e) {
            sb.append("Cannot encode: ").append(e.getMessage());
        }
        sb.append("-----END CERTIFICATE-----\n");
    }
}

