/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.storage;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.util.WebUtils;
import sqsaml.org.springframework.security.saml.parser.SAMLObject;
import sqsaml.org.springframework.security.saml.storage.SAMLMessageStorage;

public class HttpSessionStorage
implements SAMLMessageStorage {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HttpSession session;
    private Hashtable<String, SAMLObject<XMLObject>> internalMessages;
    private static final String SAML_STORAGE_KEY = "_springSamlStorageKey";

    public HttpSessionStorage(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"Request must be set");
        this.session = request.getSession(true);
    }

    public HttpSessionStorage(HttpSession session) {
        Assert.notNull((Object)session, (String)"Session must be set");
        this.session = session;
    }

    @Override
    public void storeMessage(String messageID, XMLObject message) {
        this.log.debug("Storing message {} to session {}", (Object)messageID, (Object)this.session.getId());
        Hashtable<String, SAMLObject<XMLObject>> messages = this.getMessages();
        messages.put(messageID, new SAMLObject<XMLObject>(message));
        this.updateSession(messages);
    }

    @Override
    public XMLObject retrieveMessage(String messageID) {
        Hashtable<String, SAMLObject<XMLObject>> messages = this.getMessages();
        SAMLObject<XMLObject> o = messages.get(messageID);
        if (o == null) {
            this.log.debug("Message {} not found in session {}", (Object)messageID, (Object)this.session.getId());
            return null;
        }
        this.log.debug("Message {} found in session {}, clearing", (Object)messageID, (Object)this.session.getId());
        messages.clear();
        this.updateSession(messages);
        return o.getObject();
    }

    public Set<String> getAllMessages() {
        Hashtable<String, SAMLObject<XMLObject>> messages = this.getMessages();
        return Collections.unmodifiableSet(messages.keySet());
    }

    private Hashtable<String, SAMLObject<XMLObject>> getMessages() {
        if (this.internalMessages == null) {
            this.internalMessages = this.initializeSession();
        }
        return this.internalMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable<String, SAMLObject<XMLObject>> initializeSession() {
        Hashtable<String, SAMLObject<XMLObject>> messages = (Hashtable<String, SAMLObject<XMLObject>>)this.session.getAttribute(SAML_STORAGE_KEY);
        if (messages == null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)this.session);
            synchronized (object) {
                messages = (Hashtable)this.session.getAttribute(SAML_STORAGE_KEY);
                if (messages == null) {
                    messages = new Hashtable<String, SAMLObject<XMLObject>>();
                    this.updateSession(messages);
                }
            }
        }
        return messages;
    }

    private void updateSession(Hashtable<String, SAMLObject<XMLObject>> messages) {
        this.session.setAttribute(SAML_STORAGE_KEY, messages);
    }
}

