/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.parser;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.XMLHelper;
import sqsaml.org.springframework.security.saml.parser.SAMLBase;
import sqsaml.org.springframework.security.saml.util.SAMLUtil;

public class SAMLObject<T extends XMLObject>
extends SAMLBase<T, T> {
    public SAMLObject(T object) {
        super(object);
    }

    @Override
    public T getObject() {
        if (this.object == null) {
            this.parse();
        }
        return (T)((XMLObject)super.getObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            if (this.serializedObject == null) {
                this.serializedObject = XMLHelper.nodeToString(SAMLUtil.marshallMessage((XMLObject)this.getObject()));
            }
            out.writeObject(this.serializedObject);
        }
        catch (MessageEncodingException e) {
            log.error("Error serializing SAML object", (Throwable)e);
            throw new IOException("Error serializing SAML object: " + e.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.serializedObject = (String)in.readObject();
    }

    private void parse() {
        try {
            if (this.serializedObject != null) {
                this.object = this.unmarshallMessage(new StringReader((String)((Object)this.serializedObject)));
            }
        }
        catch (MessageDecodingException e) {
            log.error("Error de-serializing SAML object", (Throwable)e);
            throw new RuntimeException("Error de-serializing SAML object: " + e.getMessage());
        }
    }
}

