/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import sqsaml.org.springframework.security.saml.SAMLCredential;

public class SAMLRelayStateSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    protected static final Logger log = LoggerFactory.getLogger(SAMLRelayStateSuccessHandler.class);

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        SAMLCredential samlCredential;
        String relayStateURL;
        Object credentials = authentication.getCredentials();
        if (credentials instanceof SAMLCredential && (relayStateURL = this.getTargetURL((samlCredential = (SAMLCredential)credentials).getRelayState())) != null) {
            log.debug("Redirecting to RelayState Url: " + relayStateURL);
            this.getRedirectStrategy().sendRedirect(request, response, relayStateURL);
            return;
        }
        super.onAuthenticationSuccess(request, response, authentication);
    }

    protected String getTargetURL(String relayState) {
        return relayState;
    }
}

