/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.reference.accesscontrol;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.User;
import sqsaml.org.owasp.esapi.errors.AccessControlException;
import sqsaml.org.owasp.esapi.errors.IntrusionException;

public class FileBasedACRs {
    private Map urlMap = new HashMap();
    private Map functionMap = new HashMap();
    private Map dataMap = new HashMap();
    private Map fileMap = new HashMap();
    private Map serviceMap = new HashMap();
    private Rule deny = new Rule();
    private Logger logger = ESAPI.getLogger("FileBasedACRs");

    public boolean isAuthorizedForURL(String url) {
        if (this.urlMap == null || this.urlMap.isEmpty()) {
            this.urlMap = this.loadRules("URLAccessRules.txt");
        }
        return this.matchRule(this.urlMap, url);
    }

    public boolean isAuthorizedForFunction(String functionName) throws AccessControlException {
        if (this.functionMap == null || this.functionMap.isEmpty()) {
            this.functionMap = this.loadRules("FunctionAccessRules.txt");
        }
        return this.matchRule(this.functionMap, functionName);
    }

    public boolean isAuthorizedForData(String action, Object data) throws AccessControlException {
        if (this.dataMap == null || this.dataMap.isEmpty()) {
            this.dataMap = this.loadDataRules("DataAccessRules.txt");
        }
        return this.matchRule(this.dataMap, (Class)data, action);
    }

    public boolean isAuthorizedForFile(String filepath) throws AccessControlException {
        if (this.fileMap == null || this.fileMap.isEmpty()) {
            this.fileMap = this.loadRules("FileAccessRules.txt");
        }
        return this.matchRule(this.fileMap, filepath.replaceAll("\\\\", "/"));
    }

    public boolean isAuthorizedForService(String serviceName) throws AccessControlException {
        if (this.serviceMap == null || this.serviceMap.isEmpty()) {
            this.serviceMap = this.loadRules("ServiceAccessRules.txt");
        }
        return this.matchRule(this.serviceMap, serviceName);
    }

    private boolean matchRule(Map map, String path) {
        User user = ESAPI.authenticator().getCurrentUser();
        Set<String> roles = user.getRoles();
        Rule rule = this.searchForRule(map, roles, path);
        return rule.allow;
    }

    private boolean matchRule(Map map, Class clazz, String action) {
        User user = ESAPI.authenticator().getCurrentUser();
        Set<String> roles = user.getRoles();
        Rule rule = this.searchForRule(map, roles, clazz, action);
        return rule != null;
    }

    private Rule searchForRule(Map map, Set roles, String path) {
        Rule rule;
        String canonical = ESAPI.encoder().canonicalize(path);
        String part = canonical;
        if (part == null) {
            part = "";
        }
        while (part.endsWith("/")) {
            part = part.substring(0, part.length() - 1);
        }
        if (part.indexOf("..") != -1) {
            throw new IntrusionException("Attempt to manipulate access control path", "Attempt to manipulate access control path: " + path);
        }
        String extension = "";
        int extIndex = part.lastIndexOf(".");
        if (extIndex != -1) {
            extension = part.substring(extIndex + 1);
        }
        if ((rule = (Rule)map.get(part)) == null) {
            rule = (Rule)map.get(part + "/*");
        }
        if (rule == null) {
            rule = (Rule)map.get("*." + extension);
        }
        if (rule != null && this.overlap(rule.roles, roles)) {
            return rule;
        }
        int slash = part.lastIndexOf(47);
        if (slash == -1) {
            return this.deny;
        }
        if ((part = part.substring(0, part.lastIndexOf(47))).length() <= 1) {
            return this.deny;
        }
        return this.searchForRule(map, roles, part);
    }

    private Rule searchForRule(Map map, Set roles, Class clazz, String action) {
        Rule rule = (Rule)map.get(clazz);
        if (rule != null && this.overlap(rule.actions, action) && this.overlap(rule.roles, roles)) {
            return rule;
        }
        return null;
    }

    private boolean overlap(Set ruleRoles, Set userRoles) {
        if (ruleRoles.contains("any")) {
            return true;
        }
        for (String role : userRoles) {
            if (!ruleRoles.contains(role)) continue;
            return true;
        }
        return false;
    }

    private boolean overlap(List ruleActions, String action) {
        return ruleActions.contains(action);
    }

    private List validateRoles(List roles) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int x = 0; x < roles.size(); ++x) {
            String canonical = ESAPI.encoder().canonicalize(((String)roles.get(x)).trim());
            if (!ESAPI.validator().isValidInput("Validating user roles in FileBasedAccessController", canonical, "RoleName", 20, false)) {
                this.logger.warning(Logger.SECURITY_FAILURE, "Role: " + ((String)roles.get(x)).trim() + " is invalid, so was not added to the list of roles for this Rule.");
                continue;
            }
            ret.add(canonical.trim());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadRules(String ruleset) {
        ruleset = "fbac-policies/" + ruleset;
        HashMap<String, Rule> map = new HashMap<String, Rule>();
        InputStream is = null;
        try {
            is = ESAPI.securityConfiguration().getResourceStream(ruleset);
            String line = "";
            while ((line = ESAPI.validator().safeReadLine(is, 500)) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                Rule rule = new Rule();
                String[] parts = line.split("\\|");
                rule.path = parts[0].trim().replaceAll("\\\\", "/");
                List roles = this.commaSplit(parts[1].trim().toLowerCase());
                roles = this.validateRoles(roles);
                for (int x = 0; x < roles.size(); ++x) {
                    rule.roles.add(((String)roles.get(x)).trim());
                }
                String action = parts[2].trim();
                rule.allow = action.equalsIgnoreCase("allow");
                if (map.containsKey(rule.path)) {
                    this.logger.warning(Logger.SECURITY_FAILURE, "Problem in access control file. Duplicate rule ignored: " + rule);
                    continue;
                }
                map.put(rule.path, rule);
            }
        }
        catch (Exception e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Problem in access control file: " + ruleset, e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                this.logger.warning(Logger.SECURITY_FAILURE, "Failure closing access control file: " + ruleset, e);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadDataRules(String ruleset) {
        HashMap<Class, Rule> map = new HashMap<Class, Rule>();
        InputStream is = null;
        try {
            ruleset = "fbac-policies/" + ruleset;
            is = ESAPI.securityConfiguration().getResourceStream(ruleset);
            String line = "";
            while ((line = ESAPI.validator().safeReadLine(is, 500)) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                Rule rule = new Rule();
                String[] parts = line.split("\\|");
                rule.clazz = Class.forName(parts[0].trim());
                List roles = this.commaSplit(parts[1].trim().toLowerCase());
                roles = this.validateRoles(roles);
                for (int x = 0; x < roles.size(); ++x) {
                    rule.roles.add(((String)roles.get(x)).trim());
                }
                List action = this.commaSplit(parts[2].trim().toLowerCase());
                for (int x = 0; x < action.size(); ++x) {
                    rule.actions.add(((String)action.get(x)).trim());
                }
                if (map.containsKey(rule.path)) {
                    this.logger.warning(Logger.SECURITY_FAILURE, "Problem in access control file. Duplicate rule ignored: " + rule);
                    continue;
                }
                map.put(rule.clazz, rule);
            }
        }
        catch (Exception e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Problem in access control file : " + ruleset, e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                this.logger.warning(Logger.SECURITY_FAILURE, "Failure closing access control file : " + ruleset, e);
            }
        }
        return map;
    }

    private List commaSplit(String input) {
        String[] array = input.split(",");
        return Arrays.asList(array);
    }

    private class Rule {
        protected String path = "";
        protected Set roles = new HashSet();
        protected boolean allow = false;
        protected Class clazz = null;
        protected List actions = new ArrayList();

        protected Rule() {
        }

        public String toString() {
            return "URL:" + this.path + " | " + this.roles + " | " + (this.allow ? "allow" : "deny");
        }
    }
}

