/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.logging.java;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.LogFactory;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.codecs.HTMLEntityCodec;
import sqsaml.org.owasp.esapi.errors.ConfigurationException;
import sqsaml.org.owasp.esapi.logging.appender.LogAppender;
import sqsaml.org.owasp.esapi.logging.appender.LogPrefixAppender;
import sqsaml.org.owasp.esapi.logging.cleaning.CodecLogScrubber;
import sqsaml.org.owasp.esapi.logging.cleaning.CompositeLogScrubber;
import sqsaml.org.owasp.esapi.logging.cleaning.LogScrubber;
import sqsaml.org.owasp.esapi.logging.cleaning.NewlineLogScrubber;
import sqsaml.org.owasp.esapi.logging.java.JavaLogBridge;
import sqsaml.org.owasp.esapi.logging.java.JavaLogBridgeImpl;
import sqsaml.org.owasp.esapi.logging.java.JavaLogLevelHandler;
import sqsaml.org.owasp.esapi.logging.java.JavaLogLevelHandlers;
import sqsaml.org.owasp.esapi.logging.java.JavaLogger;

public class JavaLogFactory
implements LogFactory {
    private static final String PROPERTY_CONFIG_MSG = "esapi-java-logging.properties is no longer supported.  See https://github.com/ESAPI/esapi-java-legacy/wiki/Configuring-the-JavaLogFactory for information on corrective actions.";
    private static final char[] IMMUNE_JAVA_HTML = new char[]{',', '.', '-', '_', ' '};
    private static final HTMLEntityCodec HTML_CODEC = new HTMLEntityCodec();
    private static LogAppender JAVA_LOG_APPENDER;
    private static LogScrubber JAVA_LOG_SCRUBBER;
    private static JavaLogBridge LOG_BRIDGE;

    static LogScrubber createLogScrubber(boolean requiresEncoding) {
        ArrayList<LogScrubber> messageScrubber = new ArrayList<LogScrubber>();
        messageScrubber.add(new NewlineLogScrubber());
        if (requiresEncoding) {
            messageScrubber.add(new CodecLogScrubber(HTML_CODEC, IMMUNE_JAVA_HTML));
        }
        return new CompositeLogScrubber(messageScrubber);
    }

    static LogAppender createLogAppender(boolean logUserInfo, boolean logClientInfo, boolean logServerIp, boolean logApplicationName, String appName) {
        return new LogPrefixAppender(logUserInfo, logClientInfo, logServerIp, logApplicationName, appName);
    }

    @Override
    public Logger getLogger(String moduleName) {
        java.util.logging.Logger javaLogger = java.util.logging.Logger.getLogger(moduleName);
        return new JavaLogger(javaLogger, LOG_BRIDGE, Integer.MIN_VALUE);
    }

    @Override
    public Logger getLogger(Class clazz) {
        java.util.logging.Logger javaLogger = java.util.logging.Logger.getLogger(clazz.getName());
        return new JavaLogger(javaLogger, LOG_BRIDGE, Integer.MIN_VALUE);
    }

    static {
        boolean encodeLog = ESAPI.securityConfiguration().getBooleanProp("Logger.LogEncodingRequired");
        JAVA_LOG_SCRUBBER = JavaLogFactory.createLogScrubber(encodeLog);
        boolean logUserInfo = ESAPI.securityConfiguration().getBooleanProp("Logger.UserInfo");
        boolean logClientInfo = ESAPI.securityConfiguration().getBooleanProp("Logger.ClientInfo");
        boolean logApplicationName = ESAPI.securityConfiguration().getBooleanProp("Logger.LogApplicationName");
        String appName = ESAPI.securityConfiguration().getStringProp("Logger.ApplicationName");
        boolean logServerIp = ESAPI.securityConfiguration().getBooleanProp("Logger.LogServerIP");
        JAVA_LOG_APPENDER = JavaLogFactory.createLogAppender(logUserInfo, logClientInfo, logServerIp, logApplicationName, appName);
        HashMap<Integer, JavaLogLevelHandler> levelLookup = new HashMap<Integer, JavaLogLevelHandler>();
        levelLookup.put(Integer.MIN_VALUE, JavaLogLevelHandlers.ALWAYS);
        levelLookup.put(100, JavaLogLevelHandlers.FINEST);
        levelLookup.put(200, JavaLogLevelHandlers.FINE);
        levelLookup.put(400, JavaLogLevelHandlers.INFO);
        levelLookup.put(800, JavaLogLevelHandlers.ERROR);
        levelLookup.put(600, JavaLogLevelHandlers.WARNING);
        levelLookup.put(1000, JavaLogLevelHandlers.SEVERE);
        LOG_BRIDGE = new JavaLogBridgeImpl(JAVA_LOG_APPENDER, JAVA_LOG_SCRUBBER, levelLookup);
        try (InputStream stream = JavaLogFactory.class.getClassLoader().getResourceAsStream("esapi-java-logging.properties");){
            if (stream != null) {
                throw new ConfigurationException(PROPERTY_CONFIG_MSG);
            }
        }
        catch (IOException ioe) {
            throw new ConfigurationException(PROPERTY_CONFIG_MSG, ioe);
        }
    }
}

