/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.logging.java;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.logging.appender.LogAppender;
import sqsaml.org.owasp.esapi.logging.cleaning.LogScrubber;
import sqsaml.org.owasp.esapi.logging.java.JavaLogBridge;
import sqsaml.org.owasp.esapi.logging.java.JavaLogLevelHandler;

public class JavaLogBridgeImpl
implements JavaLogBridge {
    private final Map<Integer, JavaLogLevelHandler> esapiJavaLevelMap;
    private final LogScrubber scrubber;
    private final LogAppender appender;

    public JavaLogBridgeImpl(LogAppender messageAppender, LogScrubber logScrubber, Map<Integer, JavaLogLevelHandler> esapiJavaHandlerMap) {
        this.esapiJavaLevelMap = new HashMap<Integer, JavaLogLevelHandler>(esapiJavaHandlerMap);
        this.scrubber = logScrubber;
        this.appender = messageAppender;
    }

    @Override
    public void log(Logger logger, int esapiLevel, Logger.EventType type, String message) {
        JavaLogLevelHandler handler = this.esapiJavaLevelMap.get(esapiLevel);
        if (handler == null) {
            throw new IllegalArgumentException("Unable to lookup Java level mapping for esapi value of " + esapiLevel);
        }
        if (handler.isEnabled(logger)) {
            String fullMessage = this.appender.appendTo(logger.getName(), type, message);
            String cleanString = this.scrubber.cleanMessage(fullMessage);
            handler.log(logger, cleanString);
        }
    }

    @Override
    public void log(Logger logger, int esapiLevel, Logger.EventType type, String message, Throwable throwable) {
        JavaLogLevelHandler handler = this.esapiJavaLevelMap.get(esapiLevel);
        if (handler == null) {
            throw new IllegalArgumentException("Unable to lookup Java level mapping for esapi value of " + esapiLevel);
        }
        if (handler.isEnabled(logger)) {
            String fullMessage = this.appender.appendTo(logger.getName(), type, message);
            String cleanString = this.scrubber.cleanMessage(fullMessage);
            handler.log(logger, cleanString, throwable);
        }
    }
}

