/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.filters;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.errors.AuthenticationException;

public class ESAPIFilter
implements Filter {
    private final Logger logger = ESAPI.getLogger("ESAPIFilter");
    private static final String[] obfuscate = new String[]{"password"};
    private String loginPage = "WEB-INF/login.jsp";
    private String publicUnauthorizedLandingPage = "WEB-INF/index.jsp";

    public void init(FilterConfig filterConfig) {
        String paramUnauthorizedPage;
        String paramLoginPage;
        String path = filterConfig.getInitParameter("resourceDirectory");
        if (path != null) {
            ESAPI.securityConfiguration().setResourceDirectory(path);
        }
        if ((paramLoginPage = filterConfig.getInitParameter("loginPage")) != null) {
            this.loginPage = paramLoginPage;
        }
        if ((paramUnauthorizedPage = filterConfig.getInitParameter("publicUnauthorizedLandingPage")) != null) {
            this.publicUnauthorizedLandingPage = paramUnauthorizedPage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        ESAPI.httpUtilities().setCurrentHTTP(request, response);
        try {
            try {
                ESAPI.authenticator().login(request, response);
            }
            catch (AuthenticationException e) {
                ESAPI.authenticator().logout();
                request.setAttribute("message", (Object)"Authentication failed");
                RequestDispatcher dispatcher = request.getRequestDispatcher(this.loginPage);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                ESAPI.clearCurrent();
                return;
            }
            ESAPI.httpUtilities().logHTTPRequest(request, this.logger, Arrays.asList(obfuscate));
            if (!ESAPI.accessController().isAuthorizedForURL(request.getRequestURI())) {
                request.setAttribute("message", (Object)"Unauthorized");
                RequestDispatcher dispatcher = request.getRequestDispatcher(this.publicUnauthorizedLandingPage);
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            ESAPI.httpUtilities().setContentType(response);
            ESAPI.httpUtilities().setNoCacheHeaders(response);
        }
        catch (Exception e) {
            this.logger.error(Logger.SECURITY_FAILURE, "Error in ESAPI security filter: " + e.getMessage(), e);
            request.setAttribute("message", (Object)e.getMessage());
        }
        finally {
            ESAPI.clearCurrent();
        }
    }

    public void destroy() {
    }
}

