/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.tsp;

import java.io.IOException;
import java.io.OutputStream;
import sqsaml.org.bouncycastle.asn1.tsp.PartialHashtree;
import sqsaml.org.bouncycastle.operator.DigestCalculator;
import sqsaml.org.bouncycastle.tsp.PartialHashTreeVerificationException;
import sqsaml.org.bouncycastle.util.Arrays;

public class PartialHashTreeProcessor {
    private final byte[][] values;

    public PartialHashTreeProcessor(PartialHashtree partialHashtree) {
        this.values = partialHashtree.getValues();
    }

    public byte[] getHash(DigestCalculator digestCalculator) {
        if (this.values.length == 1) {
            return this.values[0];
        }
        try {
            OutputStream outputStream = digestCalculator.getOutputStream();
            for (int i = 1; i != this.values.length; ++i) {
                outputStream.write(this.values[i]);
            }
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("calculator failed: " + iOException.getMessage());
        }
    }

    public void verifyContainsHash(byte[] byArray) throws PartialHashTreeVerificationException {
        if (!this.containsHash(byArray)) {
            throw new PartialHashTreeVerificationException("calculated hash is not present in partial hash tree");
        }
    }

    public boolean containsHash(byte[] byArray) {
        for (int i = 1; i != this.values.length; ++i) {
            if (!Arrays.areEqual(byArray, this.values[i])) continue;
            return true;
        }
        return false;
    }
}

