/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.pqc.jcajce.provider.saber;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import sqsaml.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import sqsaml.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import sqsaml.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import sqsaml.org.bouncycastle.pqc.jcajce.interfaces.SABERKey;
import sqsaml.org.bouncycastle.pqc.jcajce.spec.SABERParameterSpec;
import sqsaml.org.bouncycastle.util.Arrays;

public class BCSABERPublicKey
implements PublicKey,
SABERKey {
    private static final long serialVersionUID = 1L;
    private transient SABERPublicKeyParameters params;

    public BCSABERPublicKey(SABERPublicKeyParameters sABERPublicKeyParameters) {
        this.params = sABERPublicKeyParameters;
    }

    public BCSABERPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (SABERPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSABERPublicKey) {
            BCSABERPublicKey bCSABERPublicKey = (BCSABERPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSABERPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "SABER";
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public SABERParameterSpec getParameterSpec() {
        return SABERParameterSpec.fromName(this.params.getParameters().getName());
    }

    SABERPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

