/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import java.security.SecureRandom;
import sqsaml.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import sqsaml.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import sqsaml.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import sqsaml.org.bouncycastle.crypto.SecretWithEncapsulation;
import sqsaml.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqsaml.org.bouncycastle.crypto.util.DEROtherInfo;
import sqsaml.org.bouncycastle.pqc.crypto.KEMParameters;
import sqsaml.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMExtractor;
import sqsaml.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMGenerator;
import sqsaml.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import sqsaml.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import sqsaml.org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import sqsaml.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import sqsaml.org.bouncycastle.pqc.crypto.ntru.NTRUKEMExtractor;
import sqsaml.org.bouncycastle.pqc.crypto.ntru.NTRUKEMGenerator;
import sqsaml.org.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import sqsaml.org.bouncycastle.pqc.crypto.ntru.NTRUKeyPairGenerator;
import sqsaml.org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import sqsaml.org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import sqsaml.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import sqsaml.org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;

public class PQCOtherInfoGenerator {
    protected final DEROtherInfo.Builder otherInfoBuilder;
    protected final SecureRandom random;
    protected boolean used = false;

    public PQCOtherInfoGenerator(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        this.otherInfoBuilder = new DEROtherInfo.Builder(algorithmIdentifier, byArray, byArray2);
        this.random = secureRandom;
    }

    private static byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
        try {
            return SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static AsymmetricKeyParameter getPublicKey(byte[] byArray) throws IOException {
        return PublicKeyFactory.createKey(byArray);
    }

    public static class PartyU
    extends PQCOtherInfoGenerator {
        private AsymmetricCipherKeyPair aKp;
        private EncapsulatedSecretExtractor encSE;

        public PartyU(KEMParameters kEMParameters, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
            if (kEMParameters instanceof KyberParameters) {
                KyberKeyPairGenerator kyberKeyPairGenerator = new KyberKeyPairGenerator();
                kyberKeyPairGenerator.init(new KyberKeyGenerationParameters(secureRandom, (KyberParameters)kEMParameters));
                this.aKp = kyberKeyPairGenerator.generateKeyPair();
                this.encSE = new KyberKEMExtractor((KyberPrivateKeyParameters)this.aKp.getPrivate());
            } else if (kEMParameters instanceof NTRUParameters) {
                NTRUKeyPairGenerator nTRUKeyPairGenerator = new NTRUKeyPairGenerator();
                nTRUKeyPairGenerator.init(new NTRUKeyGenerationParameters(secureRandom, (NTRUParameters)((Object)kEMParameters)));
                this.aKp = nTRUKeyPairGenerator.generateKeyPair();
                this.encSE = new NTRUKEMExtractor((NTRUPrivateKeyParameters)this.aKp.getPrivate());
            } else {
                throw new IllegalArgumentException("unknown KEMParameters");
            }
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartA() {
            return PQCOtherInfoGenerator.getEncoded(this.aKp.getPublic());
        }

        public DEROtherInfo generate(byte[] byArray) {
            this.otherInfoBuilder.withSuppPrivInfo(this.encSE.extractSecret(byArray));
            return this.otherInfoBuilder.build();
        }
    }

    public static class PartyV
    extends PQCOtherInfoGenerator {
        private EncapsulatedSecretGenerator encSG;

        public PartyV(KEMParameters kEMParameters, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
            if (kEMParameters instanceof KyberParameters) {
                this.encSG = new KyberKEMGenerator(secureRandom);
            } else if (kEMParameters instanceof NTRUParameters) {
                this.encSG = new NTRUKEMGenerator(secureRandom);
            } else {
                throw new IllegalArgumentException("unknown KEMParameters");
            }
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartB(byte[] byArray) {
            this.used = false;
            try {
                SecretWithEncapsulation secretWithEncapsulation = this.encSG.generateEncapsulated(PQCOtherInfoGenerator.getPublicKey(byArray));
                this.otherInfoBuilder.withSuppPrivInfo(secretWithEncapsulation.getSecret());
                return secretWithEncapsulation.getEncapsulation();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("cannot decode public key");
            }
        }

        public DEROtherInfo generate() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return this.otherInfoBuilder.build();
        }
    }
}

