/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.pkcs;

import java.io.IOException;
import sqsaml.org.bouncycastle.asn1.ASN1Encodable;
import sqsaml.org.bouncycastle.asn1.ASN1EncodableVector;
import sqsaml.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import sqsaml.org.bouncycastle.asn1.DEROctetString;
import sqsaml.org.bouncycastle.asn1.DERSet;
import sqsaml.org.bouncycastle.asn1.pkcs.Attribute;
import sqsaml.org.bouncycastle.asn1.pkcs.CertBag;
import sqsaml.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import sqsaml.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import sqsaml.org.bouncycastle.asn1.pkcs.SafeBag;
import sqsaml.org.bouncycastle.asn1.x509.Certificate;
import sqsaml.org.bouncycastle.asn1.x509.CertificateList;
import sqsaml.org.bouncycastle.cert.X509CRLHolder;
import sqsaml.org.bouncycastle.cert.X509CertificateHolder;
import sqsaml.org.bouncycastle.operator.OutputEncryptor;
import sqsaml.org.bouncycastle.pkcs.PKCS12SafeBag;
import sqsaml.org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfoBuilder;

public class PKCS12SafeBagBuilder {
    private ASN1ObjectIdentifier bagType;
    private ASN1Encodable bagValue;
    private ASN1EncodableVector bagAttrs = new ASN1EncodableVector();

    public PKCS12SafeBagBuilder(PrivateKeyInfo privateKeyInfo, OutputEncryptor outputEncryptor) {
        this.bagType = PKCSObjectIdentifiers.pkcs8ShroudedKeyBag;
        this.bagValue = new PKCS8EncryptedPrivateKeyInfoBuilder(privateKeyInfo).build(outputEncryptor).toASN1Structure();
    }

    public PKCS12SafeBagBuilder(PrivateKeyInfo privateKeyInfo) {
        this.bagType = PKCSObjectIdentifiers.keyBag;
        this.bagValue = privateKeyInfo;
    }

    public PKCS12SafeBagBuilder(X509CertificateHolder x509CertificateHolder) throws IOException {
        this(x509CertificateHolder.toASN1Structure());
    }

    public PKCS12SafeBagBuilder(X509CRLHolder x509CRLHolder) throws IOException {
        this(x509CRLHolder.toASN1Structure());
    }

    public PKCS12SafeBagBuilder(Certificate certificate) throws IOException {
        this.bagType = PKCSObjectIdentifiers.certBag;
        this.bagValue = new CertBag(PKCSObjectIdentifiers.x509Certificate, new DEROctetString(certificate.getEncoded()));
    }

    public PKCS12SafeBagBuilder(CertificateList certificateList) throws IOException {
        this.bagType = PKCSObjectIdentifiers.crlBag;
        this.bagValue = new CertBag(PKCSObjectIdentifiers.x509Crl, new DEROctetString(certificateList.getEncoded()));
    }

    public PKCS12SafeBagBuilder addBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.bagAttrs.add(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1Encodable)));
        return this;
    }

    public PKCS12SafeBag build() {
        return new PKCS12SafeBag(new SafeBag(this.bagType, this.bagValue, new DERSet(this.bagAttrs)));
    }
}

