/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import sqsaml.org.bouncycastle.crypto.CryptoServicesRegistrar;
import sqsaml.org.bouncycastle.crypto.KeyGenerationParameters;
import sqsaml.org.bouncycastle.crypto.params.ECDomainParameters;
import sqsaml.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import sqsaml.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import sqsaml.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import sqsaml.org.bouncycastle.math.ec.ECConstants;
import sqsaml.org.bouncycastle.math.ec.ECMultiplier;
import sqsaml.org.bouncycastle.math.ec.ECPoint;
import sqsaml.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import sqsaml.org.bouncycastle.math.ec.WNafUtil;
import sqsaml.org.bouncycastle.util.BigIntegers;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
        if (this.random == null) {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while ((bigInteger = BigIntegers.createRandomBigInteger(n, this.random)).compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

