/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.cms;

import java.io.IOException;
import sqsaml.org.bouncycastle.asn1.cms.KEKIdentifier;
import sqsaml.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import sqsaml.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqsaml.org.bouncycastle.cms.AuthAttributesProvider;
import sqsaml.org.bouncycastle.cms.CMSException;
import sqsaml.org.bouncycastle.cms.CMSSecureReadable;
import sqsaml.org.bouncycastle.cms.KEKRecipient;
import sqsaml.org.bouncycastle.cms.KEKRecipientId;
import sqsaml.org.bouncycastle.cms.Recipient;
import sqsaml.org.bouncycastle.cms.RecipientInformation;
import sqsaml.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

