/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.asn1.x509;

import sqsaml.org.bouncycastle.asn1.ASN1BitString;
import sqsaml.org.bouncycastle.asn1.ASN1EncodableVector;
import sqsaml.org.bouncycastle.asn1.ASN1Object;
import sqsaml.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import sqsaml.org.bouncycastle.asn1.ASN1Primitive;
import sqsaml.org.bouncycastle.asn1.ASN1Sequence;
import sqsaml.org.bouncycastle.asn1.ASN1TaggedObject;
import sqsaml.org.bouncycastle.asn1.DERSequence;
import sqsaml.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqsaml.org.bouncycastle.asn1.x509.Extension;
import sqsaml.org.bouncycastle.asn1.x509.Extensions;
import sqsaml.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class SubjectAltPublicKeyInfo
extends ASN1Object {
    private AlgorithmIdentifier algorithm;
    private ASN1BitString subjectAltPublicKey;

    public static SubjectAltPublicKeyInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SubjectAltPublicKeyInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static SubjectAltPublicKeyInfo getInstance(Object object) {
        if (object instanceof SubjectAltPublicKeyInfo) {
            return (SubjectAltPublicKeyInfo)object;
        }
        if (object != null) {
            return new SubjectAltPublicKeyInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static SubjectAltPublicKeyInfo fromExtensions(Extensions extensions) {
        return SubjectAltPublicKeyInfo.getInstance(Extensions.getExtensionParsedValue((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAltPublicKeyInfo));
    }

    private SubjectAltPublicKeyInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("extension should contain only 2 elements");
        }
        this.algorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.subjectAltPublicKey = ASN1BitString.getInstance((Object)aSN1Sequence.getObjectAt(1));
    }

    public SubjectAltPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        this.algorithm = algorithmIdentifier;
        this.subjectAltPublicKey = aSN1BitString;
    }

    public SubjectAltPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.algorithm = subjectPublicKeyInfo.getAlgorithm();
        this.subjectAltPublicKey = subjectPublicKeyInfo.getPublicKeyData();
    }

    public AlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    public ASN1BitString getSubjectAltPublicKey() {
        return this.subjectAltPublicKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.algorithm);
        aSN1EncodableVector.add(this.subjectAltPublicKey);
        return new DERSequence(aSN1EncodableVector);
    }
}

