/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.utils.resolver.implementations;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureNodeInput;
import sqsaml.org.apache.xml.security.utils.XMLUtils;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverContext;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverException;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverSpi;

public class ResolverFragment
extends ResourceResolverSpi {
    private static final System.Logger LOG = System.getLogger(ResolverFragment.class.getName());

    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        Document doc = context.attr.getOwnerElement().getOwnerDocument();
        Node selectedElem = null;
        if (context.uriToResolve.isEmpty()) {
            LOG.log(System.Logger.Level.DEBUG, "ResolverFragment with empty URI (means complete document)");
            selectedElem = doc;
        } else {
            Element start;
            String id = context.uriToResolve.substring(1);
            selectedElem = doc.getElementById(id);
            if (selectedElem == null) {
                Object[] exArgs = new Object[]{id};
                throw new ResourceResolverException("signature.Verification.MissingID", exArgs, context.uriToResolve, context.baseUri);
            }
            if (context.secureValidation && !XMLUtils.protectAgainstWrappingAttack(start = context.attr.getOwnerDocument().getDocumentElement(), id)) {
                Object[] exArgs = new Object[]{id};
                throw new ResourceResolverException("signature.Verification.MultipleIDs", exArgs, context.uriToResolve, context.baseUri);
            }
            LOG.log(System.Logger.Level.DEBUG, "Try to catch an Element with ID {0} and Element was {1}", id, selectedElem);
        }
        XMLSignatureNodeInput result = new XMLSignatureNodeInput(selectedElem);
        result.setSecureValidation(context.secureValidation);
        result.setExcludeComments(true);
        result.setMIMEType("text/xml");
        if (context.baseUri != null && context.baseUri.length() > 0) {
            result.setSourceURI(context.baseUri.concat(context.uriToResolve));
        } else {
            result.setSourceURI(context.uriToResolve);
        }
        return result;
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext context) {
        if (context.uriToResolve == null) {
            LOG.log(System.Logger.Level.DEBUG, "Quick fail for null uri");
            return false;
        }
        if (context.uriToResolve.isEmpty() || context.uriToResolve.charAt(0) == '#' && !context.uriToResolve.startsWith("#xpointer(")) {
            LOG.log(System.Logger.Level.DEBUG, "State I can resolve reference: \"{0}\"", context.uriToResolve);
            return true;
        }
        LOG.log(System.Logger.Level.DEBUG, "Do not seem to be able to resolve reference: \"{0}\"", context.uriToResolve);
        return false;
    }
}

