/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.utils.resolver.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import sqsaml.org.apache.xml.security.signature.XMLSignatureByteInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.utils.XMLUtils;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverContext;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverException;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverSpi;

public class ResolverDirectHTTP
extends ResourceResolverSpi {
    private static final System.Logger LOG = System.getLogger(ResolverDirectHTTP.class.getName());
    private static final String[] properties = new String[]{"http.proxy.host", "http.proxy.port", "http.proxy.username", "http.proxy.password", "http.basic.username", "http.basic.password"};
    private static final int HttpProxyHost = 0;
    private static final int HttpProxyPort = 1;
    private static final int HttpProxyUser = 2;
    private static final int HttpProxyPass = 3;
    private static final int HttpBasicUser = 4;
    private static final int HttpBasicPass = 5;
    private final Map<String, String> resolverProperties;

    public ResolverDirectHTTP() {
        this.resolverProperties = Collections.emptyMap();
    }

    public ResolverDirectHTTP(Map<String, String> resolverProperties) {
        this.resolverProperties = Collections.unmodifiableMap(resolverProperties != null ? resolverProperties : Collections.emptyMap());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        try {
            URI uriNew = ResolverDirectHTTP.getNewURI(context.uriToResolve, context.baseUri);
            URL url = uriNew.toURL();
            URLConnection urlConnection = this.openConnection(url, context);
            String auth = urlConnection.getHeaderField("WWW-Authenticate");
            if (auth != null && auth.startsWith("Basic")) {
                String user = this.getProperty(context, properties[4]);
                String pass = this.getProperty(context, properties[5]);
                if (user != null && pass != null) {
                    urlConnection = this.openConnection(url, context);
                    String password = user + ":" + pass;
                    String encodedPassword = XMLUtils.encodeToString(password.getBytes(StandardCharsets.ISO_8859_1));
                    urlConnection.setRequestProperty("Authorization", "Basic " + encodedPassword);
                }
            }
            String mimeType = urlConnection.getHeaderField("Content-Type");
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                XMLSignatureByteInput xMLSignatureByteInput;
                block16: {
                    InputStream inputStream = urlConnection.getInputStream();
                    try {
                        byte[] buf = new byte[4096];
                        int read = 0;
                        int summarized = 0;
                        while ((read = inputStream.read(buf)) >= 0) {
                            baos.write(buf, 0, read);
                            summarized += read;
                        }
                        LOG.log(System.Logger.Level.DEBUG, "Fetched {0} bytes from URI {1}", summarized, uriNew.toString());
                        XMLSignatureByteInput result = new XMLSignatureByteInput(baos.toByteArray());
                        result.setSecureValidation(context.secureValidation);
                        result.setSourceURI(uriNew.toString());
                        result.setMIMEType(mimeType);
                        xMLSignatureByteInput = result;
                        if (inputStream == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream.close();
                }
                return xMLSignatureByteInput;
            }
        }
        catch (IOException | IllegalArgumentException | URISyntaxException ex) {
            throw new ResourceResolverException(ex, context.uriToResolve, context.baseUri, "generic.EmptyMessage");
        }
    }

    private URLConnection openConnection(URL url, ResourceResolverContext context) throws IOException {
        URLConnection urlConnection;
        String proxyHostProp = this.getProperty(context, properties[0]);
        String proxyPortProp = this.getProperty(context, properties[1]);
        String proxyUser = this.getProperty(context, properties[2]);
        String proxyPass = this.getProperty(context, properties[3]);
        Proxy proxy = null;
        if (proxyHostProp != null && proxyPortProp != null) {
            int port = Integer.parseInt(proxyPortProp);
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostProp, port));
        }
        if (proxy != null) {
            urlConnection = url.openConnection(proxy);
            if (proxyUser != null && proxyPass != null) {
                String password = proxyUser + ":" + proxyPass;
                String authString = "Basic " + XMLUtils.encodeToString(password.getBytes(StandardCharsets.ISO_8859_1));
                urlConnection.setRequestProperty("Proxy-Authorization", authString);
            }
        } else {
            urlConnection = url.openConnection();
        }
        return urlConnection;
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext context) {
        if (context.uriToResolve == null) {
            LOG.log(System.Logger.Level.DEBUG, "quick fail, uri == null");
            return false;
        }
        if (context.uriToResolve.isEmpty() || context.uriToResolve.charAt(0) == '#') {
            LOG.log(System.Logger.Level.DEBUG, "quick fail for empty URIs and local ones");
            return false;
        }
        LOG.log(System.Logger.Level.DEBUG, "I was asked whether I can resolve {0}", context.uriToResolve);
        if (context.uriToResolve.startsWith("http:") || context.baseUri != null && context.baseUri.startsWith("http:")) {
            LOG.log(System.Logger.Level.DEBUG, "I state that I can resolve {0}", context.uriToResolve);
            return true;
        }
        LOG.log(System.Logger.Level.DEBUG, "I state that I can't resolve {0}", context.uriToResolve);
        return false;
    }

    private static URI getNewURI(String uri, String baseURI) throws URISyntaxException {
        URI newUri = null;
        newUri = baseURI == null || baseURI.length() == 0 ? new URI(uri) : new URI(baseURI).resolve(uri);
        if (newUri.getFragment() != null) {
            return new URI(newUri.getScheme(), newUri.getSchemeSpecificPart(), null);
        }
        return newUri;
    }

    private String getProperty(ResourceResolverContext context, String propertyName) {
        if (this.resolverProperties.containsKey(propertyName)) {
            return this.resolverProperties.get(propertyName);
        }
        return context.getProperties().get(propertyName);
    }
}

