/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.keys;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sqsaml.org.apache.xml.security.encryption.EncryptedKey;
import sqsaml.org.apache.xml.security.encryption.XMLCipher;
import sqsaml.org.apache.xml.security.encryption.XMLEncryptionException;
import sqsaml.org.apache.xml.security.exceptions.XMLSecurityException;
import sqsaml.org.apache.xml.security.keys.content.DEREncodedKeyValue;
import sqsaml.org.apache.xml.security.keys.content.KeyInfoReference;
import sqsaml.org.apache.xml.security.keys.content.KeyName;
import sqsaml.org.apache.xml.security.keys.content.KeyValue;
import sqsaml.org.apache.xml.security.keys.content.MgmtData;
import sqsaml.org.apache.xml.security.keys.content.PGPData;
import sqsaml.org.apache.xml.security.keys.content.RetrievalMethod;
import sqsaml.org.apache.xml.security.keys.content.SPKIData;
import sqsaml.org.apache.xml.security.keys.content.X509Data;
import sqsaml.org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import sqsaml.org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import sqsaml.org.apache.xml.security.keys.keyresolver.KeyResolver;
import sqsaml.org.apache.xml.security.keys.keyresolver.KeyResolverException;
import sqsaml.org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import sqsaml.org.apache.xml.security.keys.storage.StorageResolver;
import sqsaml.org.apache.xml.security.transforms.Transforms;
import sqsaml.org.apache.xml.security.utils.ElementProxy;
import sqsaml.org.apache.xml.security.utils.XMLUtils;

public class KeyInfo
extends ElementProxy {
    private static final System.Logger LOG = System.getLogger(KeyInfo.class.getName());
    private List<X509Data> x509Datas;
    private List<EncryptedKey> encryptedKeys;
    private static final List<StorageResolver> nullList;
    private List<StorageResolver> storageResolvers = nullList;
    private List<KeyResolverSpi> internalKeyResolvers = new ArrayList<KeyResolverSpi>();
    private boolean secureValidation = true;

    public KeyInfo(Document doc) {
        super(doc);
        this.addReturnToSelf();
        String prefix = ElementProxy.getDefaultPrefix(this.getBaseNamespace());
        if (prefix != null && prefix.length() > 0) {
            this.getElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, this.getBaseNamespace());
        }
    }

    public KeyInfo(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
        Attr attr = element.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            element.setIdAttributeNode(attr, true);
        }
    }

    public void setSecureValidation(boolean secureValidation) {
        this.secureValidation = secureValidation;
    }

    public void setId(String id) {
        if (id != null) {
            this.setLocalIdAttribute("Id", id);
        }
    }

    public String getId() {
        return this.getLocalAttribute("Id");
    }

    public void addKeyName(String keynameString) {
        this.add(new KeyName(this.getDocument(), keynameString));
    }

    public void add(KeyName keyname) {
        this.appendSelf(keyname);
        this.addReturnToSelf();
    }

    public void addKeyValue(PublicKey pk) {
        this.add(new KeyValue(this.getDocument(), pk));
    }

    public void addKeyValue(Element unknownKeyValueElement) {
        this.add(new KeyValue(this.getDocument(), unknownKeyValueElement));
    }

    public void add(DSAKeyValue dsakeyvalue) {
        this.add(new KeyValue(this.getDocument(), dsakeyvalue));
    }

    public void add(RSAKeyValue rsakeyvalue) {
        this.add(new KeyValue(this.getDocument(), rsakeyvalue));
    }

    public void add(PublicKey pk) {
        if (KeyValue.isSupportedKeyType(pk)) {
            this.add(new KeyValue(this.getDocument(), pk));
            return;
        }
        try {
            this.add(new DEREncodedKeyValue(this.getDocument(), pk));
        }
        catch (XMLSecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void add(KeyValue keyvalue) {
        this.appendSelf(keyvalue);
        this.addReturnToSelf();
    }

    public void addMgmtData(String mgmtdata) {
        this.add(new MgmtData(this.getDocument(), mgmtdata));
    }

    public void add(MgmtData mgmtdata) {
        this.appendSelf(mgmtdata);
        this.addReturnToSelf();
    }

    public void add(PGPData pgpdata) {
        this.appendSelf(pgpdata);
        this.addReturnToSelf();
    }

    public void addRetrievalMethod(String uri, Transforms transforms, String Type2) {
        this.add(new RetrievalMethod(this.getDocument(), uri, transforms, Type2));
    }

    public void add(RetrievalMethod retrievalmethod) {
        this.appendSelf(retrievalmethod);
        this.addReturnToSelf();
    }

    public void add(SPKIData spkidata) {
        this.appendSelf(spkidata);
        this.addReturnToSelf();
    }

    public void add(X509Data x509data) {
        if (this.x509Datas == null) {
            this.x509Datas = new ArrayList<X509Data>();
        }
        this.x509Datas.add(x509data);
        this.appendSelf(x509data);
        this.addReturnToSelf();
    }

    public void add(EncryptedKey encryptedKey) throws XMLEncryptionException {
        if (this.encryptedKeys == null) {
            this.encryptedKeys = new ArrayList<EncryptedKey>();
        }
        this.encryptedKeys.add(encryptedKey);
        XMLCipher cipher = XMLCipher.getInstance();
        this.appendSelf(cipher.martial(encryptedKey));
    }

    public void addDEREncodedKeyValue(PublicKey pk) throws XMLSecurityException {
        this.add(new DEREncodedKeyValue(this.getDocument(), pk));
    }

    public void add(DEREncodedKeyValue derEncodedKeyValue) {
        this.appendSelf(derEncodedKeyValue);
        this.addReturnToSelf();
    }

    public void addKeyInfoReference(String URI2) throws XMLSecurityException {
        this.add(new KeyInfoReference(this.getDocument(), URI2));
    }

    public void add(KeyInfoReference keyInfoReference) {
        this.appendSelf(keyInfoReference);
        this.addReturnToSelf();
    }

    public void addUnknownElement(Element element) {
        this.appendSelf(element);
        this.addReturnToSelf();
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthX509Data() {
        if (this.x509Datas != null) {
            return this.x509Datas.size();
        }
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public int lengthDEREncodedKeyValue() {
        return this.length("http://www.w3.org/2009/xmldsig11#", "DEREncodedKeyValue");
    }

    public int lengthKeyInfoReference() {
        return this.length("http://www.w3.org/2009/xmldsig11#", "KeyInfoReference");
    }

    public int lengthUnknownElement() {
        int res = 0;
        for (Node childNode = this.getElement().getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1 || !childNode.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++res;
        }
        return res;
    }

    public KeyName itemKeyName(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this.getFirstChild(), "KeyName", i);
        if (e != null) {
            return new KeyName(e, this.baseURI);
        }
        return null;
    }

    public KeyValue itemKeyValue(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this.getFirstChild(), "KeyValue", i);
        if (e != null) {
            return new KeyValue(e, this.baseURI);
        }
        return null;
    }

    public MgmtData itemMgmtData(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this.getFirstChild(), "MgmtData", i);
        if (e != null) {
            return new MgmtData(e, this.baseURI);
        }
        return null;
    }

    public PGPData itemPGPData(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this.getFirstChild(), "PGPData", i);
        if (e != null) {
            return new PGPData(e, this.baseURI);
        }
        return null;
    }

    public RetrievalMethod itemRetrievalMethod(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this.getFirstChild(), "RetrievalMethod", i);
        if (e != null) {
            return new RetrievalMethod(e, this.baseURI);
        }
        return null;
    }

    public SPKIData itemSPKIData(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this.getFirstChild(), "SPKIData", i);
        if (e != null) {
            return new SPKIData(e, this.baseURI);
        }
        return null;
    }

    public X509Data itemX509Data(int i) throws XMLSecurityException {
        if (this.x509Datas != null) {
            return this.x509Datas.get(i);
        }
        Element e = XMLUtils.selectDsNode(this.getFirstChild(), "X509Data", i);
        if (e != null) {
            return new X509Data(e, this.baseURI);
        }
        return null;
    }

    public EncryptedKey itemEncryptedKey(int i) throws XMLSecurityException {
        if (this.encryptedKeys != null) {
            return this.encryptedKeys.get(i);
        }
        Element e = XMLUtils.selectXencNode(this.getFirstChild(), "EncryptedKey", i);
        if (e != null) {
            XMLCipher cipher = XMLCipher.getInstance();
            cipher.init(4, null);
            return cipher.loadEncryptedKey(e);
        }
        return null;
    }

    public DEREncodedKeyValue itemDEREncodedKeyValue(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDs11Node(this.getFirstChild(), "DEREncodedKeyValue", i);
        if (e != null) {
            return new DEREncodedKeyValue(e, this.baseURI);
        }
        return null;
    }

    public KeyInfoReference itemKeyInfoReference(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDs11Node(this.getFirstChild(), "KeyInfoReference", i);
        if (e != null) {
            return new KeyInfoReference(e, this.baseURI);
        }
        return null;
    }

    public Element itemUnknownElement(int i) {
        int res = 0;
        for (Node childNode = this.getElement().getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1 || !childNode.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || ++res != i) continue;
            return (Element)childNode;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.getFirstChild() == null;
    }

    public boolean containsKeyName() {
        return this.lengthKeyName() > 0;
    }

    public boolean containsKeyValue() {
        return this.lengthKeyValue() > 0;
    }

    public boolean containsMgmtData() {
        return this.lengthMgmtData() > 0;
    }

    public boolean containsPGPData() {
        return this.lengthPGPData() > 0;
    }

    public boolean containsRetrievalMethod() {
        return this.lengthRetrievalMethod() > 0;
    }

    public boolean containsSPKIData() {
        return this.lengthSPKIData() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public boolean containsDEREncodedKeyValue() {
        return this.lengthDEREncodedKeyValue() > 0;
    }

    public boolean containsKeyInfoReference() {
        return this.lengthKeyInfoReference() > 0;
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey pk = this.getPublicKeyFromInternalResolvers();
        if (pk != null) {
            LOG.log(System.Logger.Level.DEBUG, "I could find a key using the per-KeyInfo key resolvers");
            return pk;
        }
        LOG.log(System.Logger.Level.DEBUG, "I couldn't find a key using the per-KeyInfo key resolvers");
        pk = this.getPublicKeyFromStaticResolvers();
        if (pk != null) {
            LOG.log(System.Logger.Level.DEBUG, "I could find a key using the system-wide key resolvers");
            return pk;
        }
        LOG.log(System.Logger.Level.DEBUG, "I couldn't find a key using the system-wide key resolvers");
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        Iterator<KeyResolverSpi> it = KeyResolver.iterator();
        while (it.hasNext()) {
            KeyResolverSpi keyResolver = it.next();
            String uri = this.getBaseURI();
            for (Node currentChild = this.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                for (StorageResolver storage : this.storageResolvers) {
                    PublicKey pk = keyResolver.engineLookupAndResolvePublicKey((Element)currentChild, uri, storage, this.secureValidation);
                    if (pk == null) continue;
                    return pk;
                }
            }
        }
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        for (KeyResolverSpi keyResolver : this.internalKeyResolvers) {
            LOG.log(System.Logger.Level.DEBUG, "Try {0}", keyResolver.getClass().getName());
            String uri = this.getBaseURI();
            for (Node currentChild = this.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                for (StorageResolver storage : this.storageResolvers) {
                    PublicKey pk = keyResolver.engineLookupAndResolvePublicKey((Element)currentChild, uri, storage, this.secureValidation);
                    if (pk == null) continue;
                    return pk;
                }
            }
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate cert = this.getX509CertificateFromInternalResolvers();
        if (cert != null) {
            LOG.log(System.Logger.Level.DEBUG, "I could find a X509Certificate using the per-KeyInfo key resolvers");
            return cert;
        }
        LOG.log(System.Logger.Level.DEBUG, "I couldn't find a X509Certificate using the per-KeyInfo key resolvers");
        cert = this.getX509CertificateFromStaticResolvers();
        if (cert != null) {
            LOG.log(System.Logger.Level.DEBUG, "I could find a X509Certificate using the system-wide key resolvers");
            return cert;
        }
        LOG.log(System.Logger.Level.DEBUG, "I couldn't find a X509Certificate using the system-wide key resolvers");
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        LOG.log(System.Logger.Level.DEBUG, "Start getX509CertificateFromStaticResolvers() with {0} resolvers", KeyResolver.length());
        String uri = this.getBaseURI();
        Iterator<KeyResolverSpi> it = KeyResolver.iterator();
        while (it.hasNext()) {
            KeyResolverSpi keyResolver = it.next();
            X509Certificate cert = this.applyCurrentResolver(uri, keyResolver);
            if (cert == null) continue;
            return cert;
        }
        return null;
    }

    private X509Certificate applyCurrentResolver(String uri, KeyResolverSpi keyResolver) throws KeyResolverException {
        for (Node currentChild = this.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (currentChild.getNodeType() != 1) continue;
            for (StorageResolver storage : this.storageResolvers) {
                X509Certificate cert = keyResolver.engineLookupResolveX509Certificate((Element)currentChild, uri, storage, this.secureValidation);
                if (cert == null) continue;
                return cert;
            }
        }
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        LOG.log(System.Logger.Level.DEBUG, "Start getX509CertificateFromInternalResolvers() with {0} resolvers", this.lengthInternalKeyResolver());
        String uri = this.getBaseURI();
        for (KeyResolverSpi keyResolver : this.internalKeyResolvers) {
            LOG.log(System.Logger.Level.DEBUG, "Try {0}", keyResolver.getClass().getName());
            X509Certificate cert = this.applyCurrentResolver(uri, keyResolver);
            if (cert == null) continue;
            return cert;
        }
        return null;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        SecretKey sk = this.getSecretKeyFromInternalResolvers();
        if (sk != null) {
            LOG.log(System.Logger.Level.DEBUG, "I could find a secret key using the per-KeyInfo key resolvers");
            return sk;
        }
        LOG.log(System.Logger.Level.DEBUG, "I couldn't find a secret key using the per-KeyInfo key resolvers");
        sk = this.getSecretKeyFromStaticResolvers();
        if (sk != null) {
            LOG.log(System.Logger.Level.DEBUG, "I could find a secret key using the system-wide key resolvers");
            return sk;
        }
        LOG.log(System.Logger.Level.DEBUG, "I couldn't find a secret key using the system-wide key resolvers");
        return null;
    }

    SecretKey getSecretKeyFromStaticResolvers() throws KeyResolverException {
        Iterator<KeyResolverSpi> it = KeyResolver.iterator();
        while (it.hasNext()) {
            KeyResolverSpi keyResolver = it.next();
            String uri = this.getBaseURI();
            for (Node currentChild = this.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                for (StorageResolver storage : this.storageResolvers) {
                    SecretKey sk = keyResolver.engineLookupAndResolveSecretKey((Element)currentChild, uri, storage, this.secureValidation);
                    if (sk == null) continue;
                    return sk;
                }
            }
        }
        return null;
    }

    SecretKey getSecretKeyFromInternalResolvers() throws KeyResolverException {
        for (KeyResolverSpi keyResolver : this.internalKeyResolvers) {
            LOG.log(System.Logger.Level.DEBUG, "Try {0}", keyResolver.getClass().getName());
            String uri = this.getBaseURI();
            for (Node currentChild = this.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                for (StorageResolver storage : this.storageResolvers) {
                    SecretKey sk = keyResolver.engineLookupAndResolveSecretKey((Element)currentChild, uri, storage, this.secureValidation);
                    if (sk == null) continue;
                    return sk;
                }
            }
        }
        return null;
    }

    public PrivateKey getPrivateKey() throws KeyResolverException {
        PrivateKey pk = this.getPrivateKeyFromInternalResolvers();
        if (pk != null) {
            LOG.log(System.Logger.Level.DEBUG, "I could find a private key using the per-KeyInfo key resolvers");
            return pk;
        }
        LOG.log(System.Logger.Level.DEBUG, "I couldn't find a secret key using the per-KeyInfo key resolvers");
        pk = this.getPrivateKeyFromStaticResolvers();
        if (pk != null) {
            LOG.log(System.Logger.Level.DEBUG, "I could find a private key using the system-wide key resolvers");
            return pk;
        }
        LOG.log(System.Logger.Level.DEBUG, "I couldn't find a private key using the system-wide key resolvers");
        return null;
    }

    PrivateKey getPrivateKeyFromStaticResolvers() throws KeyResolverException {
        Iterator<KeyResolverSpi> it = KeyResolver.iterator();
        while (it.hasNext()) {
            KeyResolverSpi keyResolver = it.next();
            String uri = this.getBaseURI();
            for (Node currentChild = this.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                PrivateKey pk;
                if (currentChild.getNodeType() != 1 || (pk = keyResolver.engineLookupAndResolvePrivateKey((Element)currentChild, uri, null, this.secureValidation)) == null) continue;
                return pk;
            }
        }
        return null;
    }

    PrivateKey getPrivateKeyFromInternalResolvers() throws KeyResolverException {
        for (KeyResolverSpi keyResolver : this.internalKeyResolvers) {
            LOG.log(System.Logger.Level.DEBUG, "Try {0}", keyResolver.getClass().getName());
            String uri = this.getBaseURI();
            for (Node currentChild = this.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                PrivateKey pk;
                if (currentChild.getNodeType() != 1 || (pk = keyResolver.engineLookupAndResolvePrivateKey((Element)currentChild, uri, null, this.secureValidation)) == null) continue;
                return pk;
            }
        }
        return null;
    }

    public void registerInternalKeyResolver(KeyResolverSpi realKeyResolver) {
        this.internalKeyResolvers.add(realKeyResolver);
    }

    int lengthInternalKeyResolver() {
        return this.internalKeyResolvers.size();
    }

    KeyResolverSpi itemInternalKeyResolver(int i) {
        return this.internalKeyResolvers.get(i);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (this.storageResolvers == nullList) {
            this.storageResolvers = new ArrayList<StorageResolver>();
        }
        this.storageResolvers.add(storageResolver);
    }

    @Override
    public String getBaseLocalName() {
        return "KeyInfo";
    }

    @Override
    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    static {
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(null);
        nullList = Collections.unmodifiableList(list);
    }
}

