/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.jcp.xml.dsig.internal.dom;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sqsaml.javax.xml.crypto.Data;
import sqsaml.javax.xml.crypto.MarshalException;
import sqsaml.javax.xml.crypto.NodeSetData;
import sqsaml.javax.xml.crypto.OctetStreamData;
import sqsaml.javax.xml.crypto.URIDereferencer;
import sqsaml.javax.xml.crypto.URIReference;
import sqsaml.javax.xml.crypto.URIReferenceException;
import sqsaml.javax.xml.crypto.XMLCryptoContext;
import sqsaml.javax.xml.crypto.dom.DOMCryptoContext;
import sqsaml.javax.xml.crypto.dom.DOMURIReference;
import sqsaml.javax.xml.crypto.dsig.DigestMethod;
import sqsaml.javax.xml.crypto.dsig.Reference;
import sqsaml.javax.xml.crypto.dsig.Transform;
import sqsaml.javax.xml.crypto.dsig.TransformException;
import sqsaml.javax.xml.crypto.dsig.TransformService;
import sqsaml.javax.xml.crypto.dsig.XMLSignContext;
import sqsaml.javax.xml.crypto.dsig.XMLSignatureException;
import sqsaml.javax.xml.crypto.dsig.XMLValidateContext;
import sqsaml.org.apache.jcp.xml.dsig.internal.DigesterOutputStream;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.ApacheData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMDigestMethod;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMStructure;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMTransform;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMURIDereferencer;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.Utils;
import sqsaml.org.apache.xml.security.c14n.CanonicalizationException;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureStreamInput;
import sqsaml.org.apache.xml.security.utils.UnsyncBufferedOutputStream;
import sqsaml.org.apache.xml.security.utils.XMLUtils;

public final class DOMReference
extends DOMStructure
implements Reference,
DOMURIReference {
    public static final int MAXIMUM_TRANSFORM_COUNT = 5;
    private static boolean useC14N11 = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.org.apache.xml.internal.security.useC14N11"));
    private static final System.Logger LOG = System.getLogger(DOMReference.class.getName());
    private final DigestMethod digestMethod;
    private final String id;
    private final List<Transform> transforms;
    private List<Transform> allTransforms;
    private final Data appliedTransformData;
    private Attr here;
    private final String uri;
    private final String type;
    private byte[] digestValue;
    private byte[] calcDigestValue;
    private Element refElem;
    private boolean digested = false;
    private boolean validated = false;
    private boolean validationStatus;
    private Data derefData;
    private InputStream dis;
    private MessageDigest md;
    private Provider provider;

    public DOMReference(String uri, String type, DigestMethod dm, List<? extends Transform> transforms, String id, Provider provider) {
        this(uri, type, dm, null, null, transforms, id, null, provider);
    }

    public DOMReference(String uri, String type, DigestMethod dm, List<? extends Transform> appliedTransforms, Data result, List<? extends Transform> transforms, String id, Provider provider) {
        this(uri, type, dm, appliedTransforms, result, transforms, id, null, provider);
    }

    public DOMReference(String uri, String type, DigestMethod dm, List<? extends Transform> appliedTransforms, Data result, List<? extends Transform> transforms, String id, byte[] digestValue, Provider provider) {
        int i;
        int size;
        if (dm == null) {
            throw new NullPointerException("DigestMethod must be non-null");
        }
        if (appliedTransforms == null) {
            this.allTransforms = new ArrayList<Transform>();
        } else {
            this.allTransforms = new ArrayList<Transform>(appliedTransforms);
            size = this.allTransforms.size();
            for (i = 0; i < size; ++i) {
                if (this.allTransforms.get(i) instanceof Transform) continue;
                throw new ClassCastException("appliedTransforms[" + i + "] is not a valid type");
            }
        }
        if (transforms == null) {
            this.transforms = Collections.emptyList();
        } else {
            this.transforms = new ArrayList<Transform>(transforms);
            size = this.transforms.size();
            for (i = 0; i < size; ++i) {
                if (this.transforms.get(i) instanceof Transform) continue;
                throw new ClassCastException("transforms[" + i + "] is not a valid type");
            }
            this.allTransforms.addAll(this.transforms);
        }
        this.digestMethod = dm;
        this.uri = uri;
        if (uri != null && !uri.isEmpty()) {
            try {
                new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.type = type;
        this.id = id;
        if (digestValue != null) {
            this.digestValue = (byte[])digestValue.clone();
            this.digested = true;
        }
        this.appliedTransformData = result;
        this.provider = provider;
    }

    public DOMReference(Element refElem, XMLCryptoContext context, Provider provider) throws MarshalException {
        boolean secVal = Utils.secureValidation(context);
        Element nextSibling = DOMUtils.getFirstChildElement(refElem);
        ArrayList<Transform> newTransforms = new ArrayList<Transform>(5);
        if ("Transforms".equals(nextSibling.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(nextSibling.getNamespaceURI())) {
            Element transformElem = DOMUtils.getFirstChildElement(nextSibling, "Transform", "http://www.w3.org/2000/09/xmldsig#");
            newTransforms.add(new DOMTransform(transformElem, context, provider));
            transformElem = DOMUtils.getNextSiblingElement(transformElem);
            while (transformElem != null) {
                String localName = transformElem.getLocalName();
                String namespace = transformElem.getNamespaceURI();
                if (!"Transform".equals(localName) || !"http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
                    throw new MarshalException("Invalid element name: " + localName + ", expected Transform");
                }
                newTransforms.add(new DOMTransform(transformElem, context, provider));
                if (secVal && newTransforms.size() > 5) {
                    String error = "A maximum of 5 transforms per Reference are allowed with secure validation";
                    throw new MarshalException(error);
                }
                transformElem = DOMUtils.getNextSiblingElement(transformElem);
            }
            nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
        }
        if (!"DigestMethod".equals(nextSibling.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(nextSibling.getNamespaceURI())) {
            throw new MarshalException("Invalid element name: " + nextSibling.getLocalName() + ", expected DigestMethod");
        }
        Element dmElem = nextSibling;
        this.digestMethod = DOMDigestMethod.unmarshal(dmElem);
        String digestMethodAlgorithm = this.digestMethod.getAlgorithm();
        if (secVal && "http://www.w3.org/2001/04/xmldsig-more#md5".equals(digestMethodAlgorithm)) {
            throw new MarshalException("It is forbidden to use algorithm " + this.digestMethod + " when secure validation is enabled");
        }
        Element dvElem = DOMUtils.getNextSiblingElement(dmElem, "DigestValue", "http://www.w3.org/2000/09/xmldsig#");
        String content = XMLUtils.getFullTextChildrenFromNode(dvElem);
        this.digestValue = XMLUtils.decode(content);
        if (DOMUtils.getNextSiblingElement(dvElem) != null) {
            throw new MarshalException("Unexpected element after DigestValue element");
        }
        this.uri = DOMUtils.getAttributeValue(refElem, "URI");
        Attr attr = refElem.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            this.id = attr.getValue();
            refElem.setIdAttributeNode(attr, true);
        } else {
            this.id = null;
        }
        this.type = DOMUtils.getAttributeValue(refElem, "Type");
        this.here = refElem.getAttributeNodeNS(null, "URI");
        this.refElem = refElem;
        this.transforms = newTransforms;
        this.allTransforms = this.transforms;
        this.appliedTransformData = null;
        this.provider = provider;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public String getId() {
        return this.id;
    }

    public String getURI() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public List<Transform> getTransforms() {
        return Collections.unmodifiableList(this.allTransforms);
    }

    public byte[] getDigestValue() {
        return this.digestValue == null ? null : (byte[])this.digestValue.clone();
    }

    public byte[] getCalculatedDigestValue() {
        return this.calcDigestValue == null ? null : (byte[])this.calcDigestValue.clone();
    }

    @Override
    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        LOG.log(System.Logger.Level.DEBUG, "Marshalling Reference");
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        this.refElem = DOMUtils.createElement(ownerDoc, "Reference", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        DOMUtils.setAttributeID(this.refElem, "Id", this.id);
        DOMUtils.setAttribute(this.refElem, "URI", this.uri);
        DOMUtils.setAttribute(this.refElem, "Type", this.type);
        if (!this.allTransforms.isEmpty()) {
            Element transformsElem = DOMUtils.createElement(ownerDoc, "Transforms", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
            this.refElem.appendChild(transformsElem);
            for (Transform transform : this.allTransforms) {
                ((DOMStructure)transform).marshal(transformsElem, dsPrefix, context);
            }
        }
        ((DOMDigestMethod)this.digestMethod).marshal(this.refElem, dsPrefix, context);
        LOG.log(System.Logger.Level.DEBUG, "Adding digestValueElem");
        Element digestValueElem = DOMUtils.createElement(ownerDoc, "DigestValue", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        if (this.digestValue != null) {
            digestValueElem.appendChild(ownerDoc.createTextNode(XMLUtils.encodeToString(this.digestValue)));
        }
        this.refElem.appendChild(digestValueElem);
        parent.appendChild(this.refElem);
        this.here = this.refElem.getAttributeNodeNS(null, "URI");
    }

    public void digest(XMLSignContext signContext) throws XMLSignatureException {
        Data data = null;
        data = this.appliedTransformData == null ? this.dereference((XMLCryptoContext)signContext) : this.appliedTransformData;
        this.digestValue = this.transform(data, (XMLCryptoContext)signContext);
        String encodedDV = XMLUtils.encodeToString(this.digestValue);
        LOG.log(System.Logger.Level.DEBUG, "Reference object uri = {0}", this.uri);
        Element digestElem = DOMUtils.getLastChildElement(this.refElem);
        if (digestElem == null) {
            throw new XMLSignatureException("DigestValue element expected");
        }
        DOMUtils.removeAllChildren(digestElem);
        digestElem.appendChild(this.refElem.getOwnerDocument().createTextNode(encodedDV));
        this.digested = true;
        LOG.log(System.Logger.Level.DEBUG, "Reference digesting completed");
    }

    public boolean validate(XMLValidateContext validateContext) throws XMLSignatureException {
        if (validateContext == null) {
            throw new NullPointerException("validateContext cannot be null");
        }
        if (this.validated) {
            return this.validationStatus;
        }
        Data data = this.dereference((XMLCryptoContext)validateContext);
        this.calcDigestValue = this.transform(data, (XMLCryptoContext)validateContext);
        if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
            LOG.log(System.Logger.Level.DEBUG, "Expected digest: " + XMLUtils.encodeToString(this.digestValue));
            LOG.log(System.Logger.Level.DEBUG, "Actual digest: " + XMLUtils.encodeToString(this.calcDigestValue));
        }
        this.validationStatus = Arrays.equals(this.digestValue, this.calcDigestValue);
        this.validated = true;
        return this.validationStatus;
    }

    public Data getDereferencedData() {
        return this.derefData;
    }

    public InputStream getDigestInputStream() {
        return this.dis;
    }

    private Data dereference(XMLCryptoContext context) throws XMLSignatureException {
        Data data = null;
        URIDereferencer deref = context.getURIDereferencer();
        if (deref == null) {
            deref = DOMURIDereferencer.INSTANCE;
        }
        try {
            data = deref.dereference((URIReference)this, context);
            LOG.log(System.Logger.Level.DEBUG, "URIDereferencer class name: {0}", deref.getClass().getName());
            LOG.log(System.Logger.Level.DEBUG, "Data class name: {0}", data.getClass().getName());
        }
        catch (URIReferenceException ure) {
            throw new XMLSignatureException((Throwable)ure);
        }
        return data;
    }

    /*
     * Loose catch block
     */
    private byte[] transform(Data dereferencedData, XMLCryptoContext context) throws XMLSignatureException {
        DigesterOutputStream dos;
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance(((DOMDigestMethod)this.digestMethod).getMessageDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new XMLSignatureException((Throwable)nsae);
            }
        }
        this.md.reset();
        Boolean cache = (Boolean)context.getProperty("sqsaml.javax.xml.crypto.dsig.cacheReference");
        if (cache != null && cache.booleanValue()) {
            this.derefData = DOMReference.copyDerefData(dereferencedData);
            dos = new DigesterOutputStream(this.md, true);
        } else {
            dos = new DigesterOutputStream(this.md);
        }
        Data data = dereferencedData;
        XMLSignatureInput xi = null;
        UnsyncBufferedOutputStream os = new UnsyncBufferedOutputStream(dos);
        int size = this.transforms.size();
        for (int i = 0; i < size; ++i) {
            DOMTransform transform = (DOMTransform)this.transforms.get(i);
            data = i < size - 1 ? transform.transform(data, context) : transform.transform(data, context, os);
        }
        if (data == null) {
            LOG.log(System.Logger.Level.WARNING, "The input bytes to the digest operation are null. This may be due to a problem with the Reference URI or its Transforms.");
        } else {
            boolean c14n11 = useC14N11;
            String c14nalg = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
            if (context instanceof XMLSignContext) {
                if (!c14n11) {
                    Boolean prop = (Boolean)context.getProperty("sqsaml.org.apache.xml.security.useC14N11");
                    boolean bl = c14n11 = prop != null && prop != false;
                    if (c14n11) {
                        c14nalg = "http://www.w3.org/2006/12/xml-c14n11";
                    }
                } else {
                    c14nalg = "http://www.w3.org/2006/12/xml-c14n11";
                }
            }
            if (data instanceof ApacheData) {
                xi = ((ApacheData)data).getXMLSignatureInput();
            } else if (data instanceof OctetStreamData) {
                xi = new XMLSignatureStreamInput(((OctetStreamData)data).getOctetStream());
            } else if (data instanceof NodeSetData) {
                TransformService spi = null;
                if (this.provider == null) {
                    spi = TransformService.getInstance((String)c14nalg, (String)"DOM");
                } else {
                    try {
                        spi = TransformService.getInstance((String)c14nalg, (String)"DOM", (Provider)this.provider);
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        spi = TransformService.getInstance((String)c14nalg, (String)"DOM");
                    }
                }
                data = spi.transform(data, context);
                xi = new XMLSignatureStreamInput(((OctetStreamData)data).getOctetStream());
            } else {
                throw new XMLSignatureException("unrecognized Data type");
            }
            boolean secVal = Utils.secureValidation(context);
            xi.setSecureValidation(secVal);
            if (!(context instanceof XMLSignContext) || !c14n11 || xi.hasUnprocessedInput() || xi.isOutputStreamSet()) {
                xi.write(os);
            } else {
                TransformService spi = null;
                if (this.provider == null) {
                    spi = TransformService.getInstance((String)c14nalg, (String)"DOM");
                } else {
                    try {
                        spi = TransformService.getInstance((String)c14nalg, (String)"DOM", (Provider)this.provider);
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        spi = TransformService.getInstance((String)c14nalg, (String)"DOM");
                    }
                }
                DOMTransform t = new DOMTransform(spi);
                Element transformsElem = null;
                String dsPrefix = DOMUtils.getSignaturePrefix(context);
                if (this.allTransforms.isEmpty()) {
                    transformsElem = DOMUtils.createElement(this.refElem.getOwnerDocument(), "Transforms", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
                    this.refElem.insertBefore(transformsElem, DOMUtils.getFirstChildElement(this.refElem));
                } else {
                    transformsElem = DOMUtils.getFirstChildElement(this.refElem);
                }
                t.marshal(transformsElem, dsPrefix, (DOMCryptoContext)context);
                this.allTransforms.add(t);
                xi.write(os, true);
            }
        }
        ((OutputStream)os).flush();
        if (cache != null && cache.booleanValue()) {
            this.dis = dos.getInputStream();
        }
        byte[] byArray = dos.getDigestValue();
        ((OutputStream)os).close();
        if (xi instanceof Closeable) {
            DOMReference.close((Closeable)((Object)xi), dos);
        } else {
            DOMReference.close(dos);
        }
        return byArray;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException | NoSuchAlgorithmException | MarshalException | TransformException | CanonicalizationException e) {
                        throw new XMLSignatureException(e);
                    }
                }
                catch (Throwable throwable3) {
                    if (xi instanceof Closeable) {
                        DOMReference.close((Closeable)((Object)xi), dos);
                    } else {
                        DOMReference.close(dos);
                    }
                    throw throwable3;
                }
            }
        }
    }

    public Node getHere() {
        return this.here;
    }

    public boolean equals(Object o) {
        boolean urisEqual;
        boolean idsEqual;
        if (this == o) {
            return true;
        }
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference oref = (Reference)o;
        boolean bl = this.id == null ? oref.getId() == null : (idsEqual = this.id.equals(oref.getId()));
        boolean bl2 = this.uri == null ? oref.getURI() == null : (urisEqual = this.uri.equals(oref.getURI()));
        boolean typesEqual = this.type == null ? oref.getType() == null : this.type.equals(oref.getType());
        boolean digestValuesEqual = Arrays.equals(this.digestValue, oref.getDigestValue());
        return this.digestMethod.equals(oref.getDigestMethod()) && idsEqual && urisEqual && typesEqual && this.allTransforms.equals(oref.getTransforms()) && digestValuesEqual;
    }

    public int hashCode() {
        int result = 17;
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        if (this.uri != null) {
            result = 31 * result + this.uri.hashCode();
        }
        if (this.type != null) {
            result = 31 * result + this.type.hashCode();
        }
        if (this.digestValue != null) {
            result = 31 * result + Arrays.hashCode(this.digestValue);
        }
        result = 31 * result + this.digestMethod.hashCode();
        result = 31 * result + this.allTransforms.hashCode();
        return result;
    }

    boolean isDigested() {
        return this.digested;
    }

    private static Data copyDerefData(Data dereferencedData) {
        if (dereferencedData instanceof ApacheData) {
            ApacheData ad = (ApacheData)dereferencedData;
            XMLSignatureInput xsi = ad.getXMLSignatureInput();
            if (xsi.isNodeSet()) {
                try {
                    Set<Node> set = xsi.getNodeSet();
                    return set::iterator;
                }
                catch (Exception e) {
                    LOG.log(System.Logger.Level.WARNING, "cannot cache dereferenced data", (Throwable)e);
                    return null;
                }
            }
            if (xsi.isElement()) {
                return new DOMSubTreeData(xsi.getSubNode(), xsi.isExcludeComments());
            }
            if (xsi.hasUnprocessedInput()) {
                try {
                    return new OctetStreamData(xsi.getUnprocessedInput(), xsi.getSourceURI(), xsi.getMIMEType());
                }
                catch (IOException ioe) {
                    LOG.log(System.Logger.Level.WARNING, "cannot cache dereferenced data", (Throwable)ioe);
                    return null;
                }
            }
        }
        return dereferencedData;
    }

    private static void close(Closeable ... closeables) throws XMLSignatureException {
        XMLSignatureException collector = new XMLSignatureException("Close failed!");
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                collector.addSuppressed((Throwable)e);
            }
        }
        if (collector.getSuppressed().length > 0) {
            throw collector;
        }
    }
}

