/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.ssl;

import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import sqsaml.org.apache.commons.ssl.Certificates;
import sqsaml.org.apache.commons.ssl.SSL;
import sqsaml.org.apache.commons.ssl.TrustChain;
import sqsaml.org.apache.commons.ssl.TrustMaterial;

public class Java14TrustManagerWrapper
implements X509TrustManager {
    private final X509TrustManager trustManager;
    private final TrustChain trustChain;
    private final SSL ssl;

    public Java14TrustManagerWrapper(X509TrustManager m, TrustChain tc, SSL h) {
        this.trustManager = m;
        this.trustChain = tc;
        this.ssl = h;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.ssl.setCurrentClientChain(chain);
        CertificateException ce = null;
        try {
            this.trustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            ce = e;
        }
        this.testShouldWeThrow(ce, chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.ssl.setCurrentServerChain(chain);
        CertificateException ce = null;
        try {
            this.trustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            ce = e;
        }
        this.testShouldWeThrow(ce, chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.trustChain.containsTrustAll()) {
            return new X509Certificate[0];
        }
        return this.trustManager.getAcceptedIssuers();
    }

    private void testShouldWeThrow(CertificateException checkException, X509Certificate[] chain) throws CertificateException {
        Throwable root;
        boolean expiryProblem;
        if (checkException != null && ((expiryProblem = (root = Java14TrustManagerWrapper.getRootThrowable(checkException)) instanceof CertificateExpiredException) ? this.ssl.getCheckExpiry() : !this.trustChain.contains(TrustMaterial.TRUST_ALL))) {
            throw checkException;
        }
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate c = chain[i];
            if (this.ssl.getCheckExpiry()) {
                c.checkValidity();
            }
            if (!this.ssl.getCheckCRL()) continue;
            Certificates.checkCRL(c);
        }
    }

    private static Throwable getRootThrowable(Throwable t) {
        if (t == null) {
            return t;
        }
        Throwable cause = t.getCause();
        while (cause != null && !t.equals(cause)) {
            t = cause;
            cause = t.getCause();
        }
        return t;
    }
}

