/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.configuration;

import java.util.Iterator;
import sqsaml.org.apache.commons.configuration.AbstractConfiguration;
import sqsaml.org.apache.commons.configuration.Configuration;
import sqsaml.org.apache.commons.configuration.interpol.ConfigurationInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubsetConfiguration
extends AbstractConfiguration {
    protected Configuration parent;
    protected String prefix;
    protected String delimiter;

    public SubsetConfiguration(Configuration parent, String prefix) {
        this.parent = parent;
        this.prefix = prefix;
    }

    public SubsetConfiguration(Configuration parent, String prefix, String delimiter) {
        this.parent = parent;
        this.prefix = prefix;
        this.delimiter = delimiter;
    }

    protected String getParentKey(String key) {
        if ("".equals(key) || key == null) {
            return this.prefix;
        }
        return this.delimiter == null ? this.prefix + key : this.prefix + this.delimiter + key;
    }

    protected String getChildKey(String key) {
        if (!key.startsWith(this.prefix)) {
            throw new IllegalArgumentException("The parent key '" + key + "' is not in the subset.");
        }
        String modifiedKey = null;
        if (key.length() == this.prefix.length()) {
            modifiedKey = "";
        } else {
            int i = this.prefix.length() + (this.delimiter != null ? this.delimiter.length() : 0);
            modifiedKey = key.substring(i);
        }
        return modifiedKey;
    }

    public Configuration getParent() {
        return this.parent;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Configuration subset(String prefix) {
        return this.parent.subset(this.getParentKey(prefix));
    }

    @Override
    public boolean isEmpty() {
        return !this.getKeys().hasNext();
    }

    @Override
    public boolean containsKey(String key) {
        return this.parent.containsKey(this.getParentKey(key));
    }

    @Override
    public void addPropertyDirect(String key, Object value) {
        this.parent.addProperty(this.getParentKey(key), value);
    }

    @Override
    protected void clearPropertyDirect(String key) {
        this.parent.clearProperty(this.getParentKey(key));
    }

    @Override
    public Object getProperty(String key) {
        return this.parent.getProperty(this.getParentKey(key));
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        return new SubsetIterator(this.parent.getKeys(this.getParentKey(prefix)));
    }

    @Override
    public Iterator<String> getKeys() {
        return new SubsetIterator(this.parent.getKeys(this.prefix));
    }

    @Override
    protected Object interpolate(Object base) {
        if (this.delimiter == null && "".equals(this.prefix)) {
            return super.interpolate(base);
        }
        SubsetConfiguration config = new SubsetConfiguration(this.parent, "");
        ConfigurationInterpolator interpolator = config.getInterpolator();
        this.getInterpolator().registerLocalLookups(interpolator);
        if (this.parent instanceof AbstractConfiguration) {
            interpolator.setParentInterpolator(((AbstractConfiguration)this.parent).getInterpolator());
        }
        return config.interpolate(base);
    }

    @Override
    protected String interpolate(String base) {
        return super.interpolate(base);
    }

    @Override
    public void setThrowExceptionOnMissing(boolean throwExceptionOnMissing) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setThrowExceptionOnMissing(throwExceptionOnMissing);
        } else {
            super.setThrowExceptionOnMissing(throwExceptionOnMissing);
        }
    }

    @Override
    public boolean isThrowExceptionOnMissing() {
        if (this.parent instanceof AbstractConfiguration) {
            return ((AbstractConfiguration)this.parent).isThrowExceptionOnMissing();
        }
        return super.isThrowExceptionOnMissing();
    }

    @Override
    public char getListDelimiter() {
        return this.parent instanceof AbstractConfiguration ? ((AbstractConfiguration)this.parent).getListDelimiter() : super.getListDelimiter();
    }

    @Override
    public void setListDelimiter(char delim) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setListDelimiter(delim);
        } else {
            super.setListDelimiter(delim);
        }
    }

    @Override
    public boolean isDelimiterParsingDisabled() {
        return this.parent instanceof AbstractConfiguration ? ((AbstractConfiguration)this.parent).isDelimiterParsingDisabled() : super.isDelimiterParsingDisabled();
    }

    @Override
    public void setDelimiterParsingDisabled(boolean delimiterParsingDisabled) {
        if (this.parent instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.parent).setDelimiterParsingDisabled(delimiterParsingDisabled);
        } else {
            super.setDelimiterParsingDisabled(delimiterParsingDisabled);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubsetIterator
    implements Iterator<String> {
        private final Iterator<String> parentIterator;

        public SubsetIterator(Iterator<String> it) {
            this.parentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.parentIterator.hasNext();
        }

        @Override
        public String next() {
            return SubsetConfiguration.this.getChildKey(this.parentIterator.next());
        }

        @Override
        public void remove() {
            this.parentIterator.remove();
        }
    }
}

