/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.nu.xom.jaxen.saxpath.helpers;

import sqsaml.nu.xom.jaxen.saxpath.SAXPathException;
import sqsaml.nu.xom.jaxen.saxpath.XPathReader;

public class XPathReaderFactory {
    public static final String DRIVER_PROPERTY = "org.saxpath.driver";
    protected static final String DEFAULT_DRIVER = "sqsaml.nu.xom.jaxen.saxpath.base.XPathReader";

    private XPathReaderFactory() {
    }

    public static XPathReader createReader() throws SAXPathException {
        String string = null;
        try {
            string = System.getProperty(DRIVER_PROPERTY);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            string = DEFAULT_DRIVER;
        }
        return XPathReaderFactory.createReader(string);
    }

    public static XPathReader createReader(String string) throws SAXPathException {
        Class<?> clazz = null;
        XPathReader xPathReader = null;
        try {
            clazz = Class.forName(string, true, XPathReaderFactory.class.getClassLoader());
            if (!XPathReader.class.isAssignableFrom(clazz)) {
                throw new SAXPathException("Class [" + string + "] does not implement the org.jaxen.saxpath.XPathReader interface.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXPathException(classNotFoundException);
        }
        try {
            xPathReader = (XPathReader)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXPathException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXPathException(instantiationException);
        }
        return xPathReader;
    }
}

