/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.nu.xom.jaxen.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sqsaml.nu.xom.jaxen.Context;
import sqsaml.nu.xom.jaxen.Function;
import sqsaml.nu.xom.jaxen.JaxenException;
import sqsaml.nu.xom.jaxen.expr.DefaultExpr;
import sqsaml.nu.xom.jaxen.expr.Expr;
import sqsaml.nu.xom.jaxen.expr.FunctionCallExpr;

public class DefaultFunctionCallExpr
extends DefaultExpr
implements FunctionCallExpr {
    private static final long serialVersionUID = -4747789292572193708L;
    private String prefix;
    private String functionName;
    private List parameters;

    public DefaultFunctionCallExpr(String string, String string2) {
        this.prefix = string;
        this.functionName = string2;
        this.parameters = new ArrayList();
    }

    @Override
    public void addParameter(Expr expr) {
        this.parameters.add(expr);
    }

    @Override
    public List getParameters() {
        return this.parameters;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getPrefix();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
            stringBuffer.append(":");
        }
        stringBuffer.append(this.getFunctionName());
        stringBuffer.append("(");
        Iterator iterator = this.getParameters().iterator();
        while (iterator.hasNext()) {
            Expr expr = (Expr)iterator.next();
            stringBuffer.append(expr.getText());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public Expr simplify() {
        List list = this.getParameters();
        int n = list.size();
        ArrayList<Expr> arrayList = new ArrayList<Expr>(n);
        for (int i = 0; i < n; ++i) {
            Expr expr = (Expr)list.get(i);
            arrayList.add(expr.simplify());
        }
        this.parameters = arrayList;
        return this;
    }

    public String toString() {
        String string = this.getPrefix();
        if (string == null) {
            return "[(DefaultFunctionCallExpr): " + this.getFunctionName() + "(" + this.getParameters() + ") ]";
        }
        return "[(DefaultFunctionCallExpr): " + this.getPrefix() + ":" + this.getFunctionName() + "(" + this.getParameters() + ") ]";
    }

    @Override
    public Object evaluate(Context context) throws JaxenException {
        String string = this.getPrefix();
        String string2 = null;
        if (string != null && !"".equals(string)) {
            string2 = context.translateNamespacePrefixToUri(string);
        }
        Function function = context.getFunction(string2, string, this.getFunctionName());
        List list = this.evaluateParams(context);
        return function.call(context, list);
    }

    public List evaluateParams(Context context) throws JaxenException {
        List list = this.getParameters();
        int n = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Expr expr = (Expr)list.get(i);
            Object object = expr.evaluate(context);
            arrayList.add(object);
        }
        return arrayList;
    }
}

