/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.config;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SamlLoginRedirectFilter
implements Filter {
    private static final String BASIC_AUTH_LOGIN_URL = "/login";
    private static final String SAML_LOGIN_URL = "/auth/saml/login";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uriWithoutContextPath = this.getUriWithoutContextPath(httpRequest);
        if (BASIC_AUTH_LOGIN_URL.equals(uriWithoutContextPath)) {
            String samlLoginUriWithContextPath = this.getSamlLoginUriWithContextPath(httpRequest.getContextPath());
            httpResponse.sendRedirect(samlLoginUriWithContextPath);
            return;
        }
        chain.doFilter(request, response);
    }

    private String getUriWithoutContextPath(HttpServletRequest httpRequest) {
        String uri = httpRequest.getRequestURI();
        String contextPath = httpRequest.getContextPath();
        if (contextPath == null || contextPath.isEmpty() || "/".equals(contextPath)) {
            return uri;
        }
        return uri.substring(contextPath.length());
    }

    private String getSamlLoginUriWithContextPath(String contextPath) {
        if (contextPath.isEmpty() || "/".equals(contextPath)) {
            return SAML_LOGIN_URL;
        }
        return String.format("%s%s", contextPath, SAML_LOGIN_URL);
    }
}

