/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml;

import javax.inject.Inject;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.squashtest.tm.plugin.saml.SAMLProviderFeatures;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformation;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformationSAMLExpirationToken;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformationUser;
import org.squashtest.tm.plugin.saml.beans.FeatureAwareSAMLExpirationToken;
import sqsaml.org.springframework.security.providers.ExpiringUsernameAuthenticationToken;
import sqsaml.org.springframework.security.saml.SAMLAuthenticationProvider;
import sqsaml.org.springframework.security.saml.SAMLCredential;

public class SquashSAMLAuthProvider
extends SAMLAuthenticationProvider {
    @Inject
    private SAMLProviderFeatures features;

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication auth = this.superAuthenticate(authentication);
        UserDetails user = (UserDetails)auth.getDetails();
        FeatureAwareSAMLExpirationToken augmentedAuth = null;
        ExpiringUsernameAuthenticationToken authAsToken = (ExpiringUsernameAuthenticationToken)auth;
        if (this.containsExtraInfo(user)) {
            ExtraAccountInformation extraInformation = this.retrieveExtraInformation(user);
            augmentedAuth = new ExtraAccountInformationSAMLExpirationToken(authAsToken, this.features, extraInformation);
        } else {
            augmentedAuth = new FeatureAwareSAMLExpirationToken(authAsToken, this.features);
        }
        return augmentedAuth;
    }

    public void setFeatures(SAMLProviderFeatures features) {
        this.features = features;
    }

    private boolean containsExtraInfo(UserDetails user) {
        return ExtraAccountInformationUser.class.isAssignableFrom(user.getClass());
    }

    private ExtraAccountInformation retrieveExtraInformation(UserDetails user) {
        return ((ExtraAccountInformationUser)user).getExtraInformation();
    }

    @Override
    protected Object getPrincipal(SAMLCredential credential, Object userDetail) {
        UserDetails user = (UserDetails)userDetail;
        return user.getUsername();
    }

    protected Authentication superAuthenticate(Authentication auth) {
        return super.authenticate(auth);
    }
}

