/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import org.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import org.opensaml.saml2.metadata.provider.AbstractReloadingMetadataProvider;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ResourceBackedMetadataProvider;
import org.opensaml.util.resource.FilesystemResource;
import org.opensaml.util.resource.ResourceException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.squashtest.tm.plugin.saml.CustomSAMLBootstrap;
import org.squashtest.tm.plugin.saml.SAMLActivationSwitch;
import org.squashtest.tm.plugin.saml.SAMLProviderFeatures;
import org.squashtest.tm.plugin.saml.SquashSAMLAuthProvider;
import org.squashtest.tm.plugin.saml.SquashSAMLUserDetailsService;
import org.squashtest.tm.plugin.saml.config.SamlLoginRedirectFilter;
import org.squashtest.tm.plugin.saml.properties.HttpClientConf;
import org.squashtest.tm.plugin.saml.properties.IDPProperties;
import org.squashtest.tm.plugin.saml.properties.KeystoreProperties;
import org.squashtest.tm.plugin.saml.properties.MetadataProperties;
import org.squashtest.tm.plugin.saml.properties.ReverseProxyProperties;
import org.squashtest.tm.plugin.saml.properties.SAMLProperties;
import org.squashtest.tm.plugin.saml.properties.SPProperties;
import org.squashtest.tm.plugin.saml.properties.SessionProperties;
import sqsaml.org.apache.commons.httpclient.HostConfiguration;
import sqsaml.org.apache.commons.httpclient.HttpClient;
import sqsaml.org.apache.commons.httpclient.HttpState;
import sqsaml.org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import sqsaml.org.apache.commons.httpclient.UsernamePasswordCredentials;
import sqsaml.org.apache.commons.httpclient.auth.AuthScope;
import sqsaml.org.apache.velocity.app.VelocityEngine;
import sqsaml.org.springframework.security.saml.SAMLAuthenticationProvider;
import sqsaml.org.springframework.security.saml.SAMLBootstrap;
import sqsaml.org.springframework.security.saml.SAMLEntryPoint;
import sqsaml.org.springframework.security.saml.SAMLLogoutFilter;
import sqsaml.org.springframework.security.saml.SAMLLogoutProcessingFilter;
import sqsaml.org.springframework.security.saml.SAMLProcessingFilter;
import sqsaml.org.springframework.security.saml.SAMLWebSSOHoKProcessingFilter;
import sqsaml.org.springframework.security.saml.context.SAMLContextProvider;
import sqsaml.org.springframework.security.saml.context.SAMLContextProviderImpl;
import sqsaml.org.springframework.security.saml.context.SAMLContextProviderLB;
import sqsaml.org.springframework.security.saml.key.JKSKeyManager;
import sqsaml.org.springframework.security.saml.key.KeyManager;
import sqsaml.org.springframework.security.saml.log.SAMLDefaultLogger;
import sqsaml.org.springframework.security.saml.metadata.CachingMetadataManager;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadata;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import sqsaml.org.springframework.security.saml.metadata.MetadataDisplayFilter;
import sqsaml.org.springframework.security.saml.metadata.MetadataManager;
import sqsaml.org.springframework.security.saml.parser.ParserPoolHolder;
import sqsaml.org.springframework.security.saml.processor.HTTPArtifactBinding;
import sqsaml.org.springframework.security.saml.processor.HTTPPAOS11Binding;
import sqsaml.org.springframework.security.saml.processor.HTTPPostBinding;
import sqsaml.org.springframework.security.saml.processor.HTTPRedirectDeflateBinding;
import sqsaml.org.springframework.security.saml.processor.HTTPSOAP11Binding;
import sqsaml.org.springframework.security.saml.processor.SAMLBinding;
import sqsaml.org.springframework.security.saml.processor.SAMLProcessorImpl;
import sqsaml.org.springframework.security.saml.util.VelocityFactory;
import sqsaml.org.springframework.security.saml.websso.ArtifactResolutionProfile;
import sqsaml.org.springframework.security.saml.websso.ArtifactResolutionProfileImpl;
import sqsaml.org.springframework.security.saml.websso.SingleLogoutProfile;
import sqsaml.org.springframework.security.saml.websso.SingleLogoutProfileImpl;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfile;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileConsumer;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileConsumerHoKImpl;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileECPImpl;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileHoKImpl;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileImpl;
import sqsaml.org.springframework.security.saml.websso.WebSSOProfileOptions;

@Configuration
@EnableConfigurationProperties(value={SAMLProperties.class})
@SAMLActivationSwitch
public class SAMLConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAMLConfig.class);
    public static final String SAML_PROVIDER_NAME = "saml";
    private final MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
    @Inject
    private SAMLProperties samlProperties;
    @Value(value="${squash.path.config-path}")
    private String confFolder;

    @PreDestroy
    public void destroy() {
        this.multiThreadedHttpConnectionManager.shutdown();
    }

    @Bean
    @Order(value=1000)
    public SecurityFilterChain samlSecurityFilterChain(HttpSecurity http) throws Exception {
        AuthenticationManager authenticationManager = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
        ((HttpSecurity)http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.samlEntryPoint()).and()).addFilterBefore((Filter)this.samlFilter(authenticationManager), BasicAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public SAMLEntryPoint samlEntryPoint() throws Exception {
        LOGGER.info("initializing : samlEntryPoint");
        SAMLEntryPoint samlEntryPoint = new SAMLEntryPoint();
        samlEntryPoint.setDefaultProfileOptions(this.samlWebSSOProfileOptions());
        samlEntryPoint.setWebSSOprofile(this.samlWebSSOprofile());
        samlEntryPoint.setWebSSOprofileECP(this.samlEcpProfile());
        samlEntryPoint.setWebSSOprofileHoK(this.samlHokWebSSOProfile());
        samlEntryPoint.setSamlLogger(this.samlLogger());
        samlEntryPoint.setContextProvider(this.samlContextProvider());
        samlEntryPoint.setMetadata(this.samlMetadataManager());
        return samlEntryPoint;
    }

    @Bean
    @ConditionalOnProperty(value={"authentication.provider"}, havingValue="saml")
    public SamlLoginRedirectFilter samlLoginRedirectFilter() {
        LOGGER.info("initializing : samlLoginRedirectFilter");
        return new SamlLoginRedirectFilter();
    }

    @Bean
    public WebSSOProfileOptions samlWebSSOProfileOptions() {
        LOGGER.info("initializing : samlWebSSOProfileOptions");
        return this.samlProperties.getSso();
    }

    @Bean
    public FilterChainProxy samlFilter(AuthenticationManager authenticationManager) throws Exception {
        LOGGER.info("initializing : samlFilter");
        ArrayList<DefaultSecurityFilterChain> chains = new ArrayList<DefaultSecurityFilterChain>();
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/auth/saml/login/**"), new Filter[]{this.samlEntryPoint()}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/auth/saml/logout/**"), new Filter[]{this.samlLogoutFilter()}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/auth/saml/metadata/**"), new Filter[]{this.samlMetadataDisplayFilter()}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/auth/saml/SSO/**"), new Filter[]{this.samlWebSSOProcessingFilter(authenticationManager)}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/auth/saml/SSOHoK/**"), new Filter[]{this.samlWebSSOHoKProcessingFilter(authenticationManager)}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/auth/saml/SingleLogout/**"), new Filter[]{this.samlLogoutProcessingFilter()}));
        return new FilterChainProxy(chains);
    }

    @Bean
    public MetadataDisplayFilter samlMetadataDisplayFilter() {
        LOGGER.info("initializing : samlMetadataDisplayFilter");
        return new MetadataDisplayFilter();
    }

    @Bean
    public SavedRequestAwareAuthenticationSuccessHandler samlSuccessRedirectHandler() {
        LOGGER.info("initializing : samlSuccessRedirectHandler");
        SavedRequestAwareAuthenticationSuccessHandler successRedirectHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        successRedirectHandler.setDefaultTargetUrl("/");
        return successRedirectHandler;
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler samlAuthenticationFailureHandler() {
        LOGGER.info("initializing : samlAuthenticationFailureHandler");
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setDefaultFailureUrl("/auth/saml/authentication-failure");
        return failureHandler;
    }

    @Bean
    public SAMLProcessingFilter samlWebSSOProcessingFilter(AuthenticationManager authenticationManager) {
        LOGGER.info("initializing : samlWebSSOProcessingFilter");
        SAMLProcessingFilter filter = new SAMLProcessingFilter();
        filter.setAuthenticationManager(authenticationManager);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.samlSuccessRedirectHandler());
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.samlAuthenticationFailureHandler());
        return filter;
    }

    @Bean
    public SAMLWebSSOHoKProcessingFilter samlWebSSOHoKProcessingFilter(AuthenticationManager authenticationManager) {
        LOGGER.info("initializing : samlWebSSOHoKProcessingFilter");
        SAMLWebSSOHoKProcessingFilter filter = new SAMLWebSSOHoKProcessingFilter();
        filter.setAuthenticationManager(authenticationManager);
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.samlSuccessRedirectHandler());
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.samlAuthenticationFailureHandler());
        return filter;
    }

    public SecurityContextLogoutHandler samlLogoutHandler() {
        LOGGER.info("initializing : samlLogoutHandler");
        SecurityContextLogoutHandler logoutHandler = new SecurityContextLogoutHandler();
        logoutHandler.setInvalidateHttpSession(true);
        logoutHandler.setClearAuthentication(true);
        return logoutHandler;
    }

    @Bean
    public SAMLLogoutProcessingFilter samlLogoutProcessingFilter() {
        LOGGER.info("initializing : samlLogoutProcessingFilter");
        return new SAMLLogoutProcessingFilter("/", new LogoutHandler[]{this.samlLogoutHandler()});
    }

    @Bean
    public SAMLLogoutFilter samlLogoutFilter() {
        LOGGER.info("initializing : samlLogoutFilter");
        return new SAMLLogoutFilter("/", new LogoutHandler[]{this.samlLogoutHandler()}, new LogoutHandler[]{this.samlLogoutHandler()});
    }

    @Bean
    public VelocityEngine samlVelocityEngine() {
        LOGGER.info("initializing : samlVelocityEngine");
        return VelocityFactory.getEngine();
    }

    @Bean(initMethod="initialize")
    public ParserPool samlParserPool() {
        LOGGER.info("initializing : samlParserPool");
        return new StaticBasicParserPool();
    }

    @Bean
    public ParserPoolHolder samlParserPoolHolder() {
        LOGGER.info("initializing : samlParserPoolHolder");
        return new ParserPoolHolder();
    }

    @Bean
    public SAMLAuthenticationProvider samlAuthenticationProvider() {
        LOGGER.info("initializing : samlAuthenticationProvider");
        SquashSAMLAuthProvider provider = new SquashSAMLAuthProvider();
        provider.setExcludeCredential(true);
        provider.setConsumer(this.samlWebSSOprofileConsumer());
        provider.setHokConsumer(this.samlHokWebSSOprofileConsumer());
        provider.setSamlLogger(this.samlLogger());
        provider.setUserDetails(this.samlUserDetailsService());
        provider.setFeatures(this.samlProviderFeatures());
        return provider;
    }

    @Bean
    public SAMLProviderFeatures samlProviderFeatures() {
        return new SAMLProviderFeatures();
    }

    @Bean
    public SquashSAMLUserDetailsService samlUserDetailsService() {
        return new SquashSAMLUserDetailsService(this.samlProperties.getUserMapping());
    }

    @Bean
    public SAMLContextProvider samlContextProvider() {
        SAMLContextProviderImpl contextProvider;
        LOGGER.info("initializing : samlContextProvider");
        ReverseProxyProperties proxy = this.samlProperties.getProxy();
        if (proxy.isEnabled()) {
            LOGGER.trace("using the reverse-proxy friendly implementation");
            SAMLContextProviderLB provider = new SAMLContextProviderLB();
            provider.setScheme(proxy.getScheme());
            provider.setContextPath(proxy.getContextPath());
            provider.setIncludeServerPortInRequestURL(proxy.isIncludePortInUrl());
            provider.setServerName(proxy.getServerName());
            provider.setServerPort(proxy.getServerPort());
            contextProvider = provider;
        } else {
            LOGGER.trace("using the standard implementation");
            contextProvider = new SAMLContextProviderImpl();
        }
        return contextProvider;
    }

    @Bean
    public static SAMLBootstrap samlBootstrap() {
        LOGGER.info("initializing : samlBootstrap");
        return new CustomSAMLBootstrap();
    }

    @Bean
    public SAMLDefaultLogger samlLogger() {
        LOGGER.info("initializing : samlLogger");
        return new SAMLDefaultLogger();
    }

    @Bean(value={"webSSOprofile"})
    public WebSSOProfile samlWebSSOprofile() {
        LOGGER.info("initializing : samlWebSSOprofile");
        return new WebSSOProfileImpl();
    }

    @Bean(value={"webSSOprofileConsumer"})
    public WebSSOProfileConsumer samlWebSSOprofileConsumer() {
        LOGGER.info("initializing : samlWebSSOprofileConsumer");
        SessionProperties session = this.samlProperties.getSession();
        WebSSOProfileConsumerImpl consumer = new WebSSOProfileConsumerImpl();
        consumer.setMaxAuthenticationAge(session.getMaxAuthTime());
        consumer.setMaxAssertionTime(session.getMaxAssertionTime());
        return consumer;
    }

    @Bean(value={"hokWebSSOProfile"})
    public WebSSOProfile samlHokWebSSOProfile() {
        LOGGER.info("initializing : samlHokWebSSOProfile");
        return new WebSSOProfileHoKImpl();
    }

    @Bean(value={"hokWebSSOprofileConsumer"})
    public WebSSOProfileConsumerHoKImpl samlHokWebSSOprofileConsumer() {
        LOGGER.info("initializing : samlHokWebSSOprofileConsumer");
        SessionProperties session = this.samlProperties.getSession();
        WebSSOProfileConsumerHoKImpl consumer = new WebSSOProfileConsumerHoKImpl();
        consumer.setMaxAuthenticationAge(session.getMaxAuthTime());
        consumer.setMaxAssertionTime(session.getMaxAssertionTime());
        return consumer;
    }

    @Bean(value={"ecpprofile"})
    public WebSSOProfile samlEcpProfile() {
        LOGGER.info("initializing : samlEcpProfile");
        return new WebSSOProfileECPImpl();
    }

    @Bean
    public SingleLogoutProfile samlLogoutProfile() {
        LOGGER.info("initializing : samlLogoutProfile");
        return new SingleLogoutProfileImpl();
    }

    private HttpClient baseSamlHttpClient(HttpClientConf params) {
        HttpClient client = new HttpClient(this.multiThreadedHttpConnectionManager);
        if (params.hasProxy()) {
            HostConfiguration host = client.getHostConfiguration();
            host.setProxy(params.getHost(), params.getPort());
        }
        if (params.hasBasicCredentials()) {
            HttpState state = client.getState();
            state.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(params.getUsername(), params.getPassword()));
        }
        return client;
    }

    private ArtifactResolutionProfile samlArtifactResolutionProfile() throws Exception {
        LOGGER.info("initializing : samlArtifactResolutionProfile");
        IDPProperties props = this.samlProperties.getIdp();
        HttpClient httpClient = this.baseSamlHttpClient(props.getHttpConf());
        ArtifactResolutionProfileImpl artifactResolutionProfile = new ArtifactResolutionProfileImpl(httpClient);
        HTTPSOAP11Binding soapBinding = new HTTPSOAP11Binding(this.samlParserPool());
        artifactResolutionProfile.setProcessor(new SAMLProcessorImpl(soapBinding));
        artifactResolutionProfile.setMetadata(this.samlMetadataManager());
        artifactResolutionProfile.afterPropertiesSet();
        return artifactResolutionProfile;
    }

    @Bean
    public HTTPArtifactBinding samlArtifactBinding() throws Exception {
        LOGGER.info("initializing : samlArtifactBinding");
        return new HTTPArtifactBinding(this.samlParserPool(), this.samlVelocityEngine(), this.samlArtifactResolutionProfile());
    }

    @Bean
    public HTTPPostBinding samlHttpPostBinding() {
        LOGGER.info("initializing : samlHttpPostBinding");
        return new HTTPPostBinding(this.samlParserPool(), this.samlVelocityEngine());
    }

    @Bean
    public HTTPRedirectDeflateBinding samlHttpRedirectDeflateBinding() {
        LOGGER.info("initializing : samlHttpRedirectDeflateBinding");
        return new HTTPRedirectDeflateBinding(this.samlParserPool());
    }

    @Bean
    public HTTPSOAP11Binding samlHttpSOAP11Binding() {
        LOGGER.info("initializing : samlHttpSOAP11Binding");
        return new HTTPSOAP11Binding(this.samlParserPool());
    }

    @Bean
    public HTTPPAOS11Binding samlHttpPAOS11Binding() {
        LOGGER.info("initializing : samlHttpPAOS11Binding");
        return new HTTPPAOS11Binding(this.samlParserPool());
    }

    @Bean
    public SAMLProcessorImpl samlProcessor() throws Exception {
        LOGGER.info("initializing : samlProcessor");
        ArrayList<SAMLBinding> bindings = new ArrayList<SAMLBinding>();
        bindings.add(this.samlHttpRedirectDeflateBinding());
        bindings.add(this.samlHttpPostBinding());
        bindings.add(this.samlArtifactBinding());
        bindings.add(this.samlHttpSOAP11Binding());
        bindings.add(this.samlHttpPAOS11Binding());
        return new SAMLProcessorImpl(bindings);
    }

    @Bean
    public KeyManager samlKeyManager() {
        LOGGER.info("initializing : samlKeyManager");
        KeystoreProperties properties = this.samlProperties.getKeystore();
        Resource storeFile = this.findKeystoreResource(properties.getUrl());
        String storePass = properties.getPassword();
        Map<String, String> credentials = properties.getCredentials();
        String defaultKey = properties.getDefaultKey();
        return new JKSKeyManager(storeFile, storePass, credentials, defaultKey);
    }

    @Bean(value={"metadata"})
    public MetadataManager samlMetadataManager() throws MetadataProviderException {
        LOGGER.info("initializing : samlMetadataManager");
        List<MetadataProvider> providers = Arrays.asList(this.samlSPMetadataProvider(), this.samlIDPMetadataProvider());
        CachingMetadataManager manager = new CachingMetadataManager(providers);
        manager.setRefreshCheckInterval(3600000L);
        return manager;
    }

    @Bean
    public MetadataProvider samlSPMetadataProvider() {
        LOGGER.info("initializing : samlSPMetadataProvider");
        SPProperties sp = this.samlProperties.getSp();
        MetadataProperties metaprops = sp.getMetadata();
        ExtendedMetadataDelegate metaProvider = this.getExtendedMetadataDelegate(metaprops, this.samlSPExtendedMetadata());
        sp.configure(metaProvider);
        return metaProvider;
    }

    @Bean
    public MetadataProvider samlIDPMetadataProvider() {
        LOGGER.info("initializing : samlIDPMetadataProvider");
        IDPProperties idp = this.samlProperties.getIdp();
        MetadataProperties metaprops = idp.getMetadata();
        ExtendedMetadataDelegate metaProvider = this.getExtendedMetadataDelegate(metaprops, this.samlIDPExtendedMetadata());
        idp.configure(metaProvider);
        return metaProvider;
    }

    private ExtendedMetadataDelegate getExtendedMetadataDelegate(MetadataProperties metaprops, ExtendedMetadata extendedMetadata) {
        try {
            AbstractMetadataProvider provider = this.createProvider(metaprops.getUrl());
            provider.setParserPool(this.samlParserPool());
            return new ExtendedMetadataDelegate((MetadataProvider)provider, extendedMetadata);
        }
        catch (MetadataProviderException | ResourceException e) {
            throw new RuntimeException("Unable to create the metadata provider", e);
        }
    }

    @Bean
    public ExtendedMetadata samlIDPExtendedMetadata() {
        LOGGER.info("initializing : samlIDPExtendedMetadata");
        IDPProperties props = this.samlProperties.getIdp();
        ExtendedMetadata meta = new ExtendedMetadata();
        props.configure(meta);
        return meta;
    }

    @Bean
    public ExtendedMetadata samlSPExtendedMetadata() {
        LOGGER.info("initializing : samlSPExtendedMetadata");
        SPProperties sp = this.samlProperties.getSp();
        ExtendedMetadata meta = new ExtendedMetadata();
        sp.configure(meta);
        return meta;
    }

    private String resolvePath(String path) {
        String finalPath = null;
        if (path.startsWith("file:")) {
            LOGGER.trace("path {} use the file protocol ", (Object)path);
            finalPath = this.resolveAbsoluteUrlPath(path);
        } else {
            LOGGER.trace("path {} is a relative path", (Object)path);
            finalPath = this.resolveRelativePath(path);
        }
        return finalPath;
    }

    private String resolveRelativePath(String relativePath) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(this.resolveUrlPath(this.confFolder));
        if (!this.confFolder.endsWith("/")) {
            pathBuilder.append("/");
        }
        pathBuilder.append(relativePath);
        return pathBuilder.toString();
    }

    private String resolveAbsoluteUrlPath(String path) {
        try {
            URI uri = new URI(path);
            String uriPath = uri.getPath();
            return Objects.nonNull(uriPath) ? uriPath : this.resolveUrlPath(path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The path " + path + " is not valid", e);
        }
    }

    private String resolveUrlPath(String path) {
        return path.replaceFirst("^(\\w+):(//)?", "");
    }

    private Resource findKeystoreResource(String keystoreUrl) {
        return new PathResource(this.resolvePath(keystoreUrl));
    }

    private AbstractMetadataProvider createProvider(String url) throws MetadataProviderException, ResourceException {
        LOGGER.debug("resolving resource {}", (Object)url);
        boolean isHttp = url.startsWith("http");
        AbstractReloadingMetadataProvider provider = null;
        if (isHttp) {
            LOGGER.debug("resource accessible by http(s)");
            provider = new HTTPMetadataProvider(new Timer(), this.baseSamlHttpClient(HttpClientConf.DEFAULT), url);
        } else {
            String path = this.resolvePath(url);
            LOGGER.debug("resource accessible by file path {}", (Object)path);
            FilesystemResource file = new FilesystemResource(path);
            provider = new ResourceBackedMetadataProvider(new Timer(), file);
        }
        return provider;
    }

    @Configuration
    @Order(value=1)
    public static class SamlGlobalAuthenticationConfig
    extends GlobalAuthenticationConfigurerAdapter {
        @Inject
        @Named(value="samlAuthenticationProvider")
        private SAMLAuthenticationProvider samlAuthenticationProvider;

        public void configure(AuthenticationManagerBuilder auth) {
            auth.authenticationProvider((AuthenticationProvider)this.samlAuthenticationProvider);
            auth.eraseCredentials(true);
        }
    }
}

