/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security;

import org.opensaml.common.SignableSAMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.SignatureImpl;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sqsaml.org.apache.xml.security.exceptions.XMLSecurityException;
import sqsaml.org.apache.xml.security.signature.Reference;
import sqsaml.org.apache.xml.security.signature.XMLSignature;
import sqsaml.org.apache.xml.security.transforms.Transform;
import sqsaml.org.apache.xml.security.transforms.TransformationException;
import sqsaml.org.apache.xml.security.transforms.Transforms;
import sqsaml.org.apache.xml.security.utils.IdResolver;

public class SAMLSignatureProfileValidator
implements Validator<Signature> {
    private final Logger log = LoggerFactory.getLogger(SAMLSignatureProfileValidator.class);

    @Override
    public void validate(Signature signature) throws ValidationException {
        if (!(signature instanceof SignatureImpl)) {
            this.log.info("Signature was not an instance of SignatureImpl, was {} validation not supported", (Object)signature.getClass().getName());
            return;
        }
        this.validateSignatureImpl((SignatureImpl)signature);
    }

    protected void validateSignatureImpl(SignatureImpl sigImpl) throws ValidationException {
        if (sigImpl.getXMLSignature() == null) {
            this.log.error("SignatureImpl did not contain the an Apache XMLSignature child");
            throw new ValidationException("Apache XMLSignature does not exist on SignatureImpl");
        }
        XMLSignature apacheSig = sigImpl.getXMLSignature();
        if (!(sigImpl.getParent() instanceof SignableSAMLObject)) {
            this.log.error("Signature is not an immedidate child of a SignableSAMLObject");
            throw new ValidationException("Signature is not an immediate child of a SignableSAMLObject.");
        }
        SignableSAMLObject signableObject = (SignableSAMLObject)sigImpl.getParent();
        Reference ref = this.validateReference(apacheSig);
        String uri = ref.getURI();
        this.validateReferenceURI(uri, signableObject);
        this.validateTransforms(ref);
        this.validateObjectChildren(apacheSig);
    }

    protected Reference validateReference(XMLSignature apacheSig) throws ValidationException {
        int numReferences = apacheSig.getSignedInfo().getLength();
        if (numReferences != 1) {
            this.log.error("Signature SignedInfo had invalid number of References: " + numReferences);
            throw new ValidationException("Signature SignedInfo must have exactly 1 Reference element");
        }
        Reference ref = null;
        try {
            ref = apacheSig.getSignedInfo().item(0);
        }
        catch (XMLSecurityException e) {
            this.log.error("Apache XML Security exception obtaining Reference", (Throwable)e);
            throw new ValidationException("Could not obtain Reference from Signature/SignedInfo", e);
        }
        if (ref == null) {
            this.log.error("Signature Reference was null");
            throw new ValidationException("Signature Reference was null");
        }
        return ref;
    }

    protected void validateReferenceURI(String uri, SignableSAMLObject signableObject) throws ValidationException {
        String id = signableObject.getSignatureReferenceID();
        this.validateReferenceURI(uri, id);
        if (DatatypeHelper.isEmpty(uri)) {
            return;
        }
        String uriID = uri.substring(1);
        Element expected = signableObject.getDOM();
        if (expected == null) {
            this.log.error("SignableSAMLObject does not have a cached DOM Element.");
            throw new ValidationException("SignableSAMLObject does not have a cached DOM Element.");
        }
        Document doc = expected.getOwnerDocument();
        Element resolved = IdResolver.getElementById(doc, uriID);
        if (resolved == null) {
            this.log.error("Apache xmlsec IdResolver could not resolve the Element for id reference: {}", (Object)uriID);
            throw new ValidationException("Apache xmlsec IdResolver could not resolve the Element for id reference: " + uriID);
        }
        if (!expected.isSameNode(resolved)) {
            this.log.error("Signature Reference URI '{}' did not resolve to the expected parent Element", (Object)uri);
            throw new ValidationException("Signature Reference URI did not resolve to the expected parent Element");
        }
    }

    protected void validateReferenceURI(String uri, String id) throws ValidationException {
        if (!DatatypeHelper.isEmpty(uri)) {
            if (!uri.startsWith("#")) {
                this.log.error("Signature Reference URI was not a document fragment reference: " + uri);
                throw new ValidationException("Signature Reference URI was not a document fragment reference");
            }
            if (DatatypeHelper.isEmpty(id)) {
                this.log.error("SignableSAMLObject did not contain an ID attribute");
                throw new ValidationException("SignableSAMLObject did not contain an ID attribute");
            }
            if (uri.length() < 2 || !id.equals(uri.substring(1))) {
                this.log.error("Reference URI '{}' did not point to SignableSAMLObject with ID '{}'", (Object)uri, (Object)id);
                throw new ValidationException("Reference URI did not point to parent ID");
            }
        }
    }

    protected void validateTransforms(Reference reference) throws ValidationException {
        Transforms transforms = null;
        try {
            transforms = reference.getTransforms();
        }
        catch (XMLSecurityException e) {
            this.log.error("Apache XML Security error obtaining Transforms instance", (Throwable)e);
            throw new ValidationException("Apache XML Security error obtaining Transforms instance", e);
        }
        if (transforms == null) {
            this.log.error("Error obtaining Transforms instance, null was returned");
            throw new ValidationException("Transforms instance was null");
        }
        int numTransforms = transforms.getLength();
        if (numTransforms > 2) {
            this.log.error("Invalid number of Transforms was present: " + numTransforms);
            throw new ValidationException("Invalid number of transforms");
        }
        boolean sawEnveloped = false;
        for (int i = 0; i < numTransforms; ++i) {
            Transform transform = null;
            try {
                transform = transforms.item(i);
            }
            catch (TransformationException e) {
                this.log.error("Error obtaining transform instance", (Throwable)e);
                throw new ValidationException("Error obtaining transform instance", e);
            }
            String uri = transform.getURI();
            if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(uri)) {
                this.log.debug("Saw Enveloped signature transform");
                sawEnveloped = true;
                continue;
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(uri) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(uri)) {
                this.log.debug("Saw Exclusive C14N signature transform");
                continue;
            }
            this.log.error("Saw invalid signature transform: " + uri);
            throw new ValidationException("Signature contained an invalid transform");
        }
        if (!sawEnveloped) {
            this.log.error("Signature was missing the required Enveloped signature transform");
            throw new ValidationException("Transforms did not contain the required enveloped transform");
        }
    }

    protected void validateObjectChildren(XMLSignature apacheSig) throws ValidationException {
        if (apacheSig.getObjectLength() > 0) {
            this.log.error("Signature contained {} ds:Object child element(s)", (Object)apacheSig.getObjectLength());
            throw new ValidationException("Signature contained illegal ds:Object children");
        }
    }
}

