/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.impl;

import java.util.Map;
import javax.xml.namespace.QName;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.common.impl.AbstractSAMLObjectMarshaller;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class EntityDescriptorMarshaller
extends AbstractSAMLObjectMarshaller {
    private final Logger log = LoggerFactory.getLogger(EntityDescriptorMarshaller.class);

    @Override
    protected void marshallAttributes(XMLObject samlElement, Element domElement) {
        EntityDescriptor entityDescriptor = (EntityDescriptor)samlElement;
        if (entityDescriptor.getEntityID() != null) {
            domElement.setAttributeNS(null, "entityID", entityDescriptor.getEntityID());
        }
        if (entityDescriptor.getID() != null) {
            domElement.setAttributeNS(null, "ID", entityDescriptor.getID());
            domElement.setIdAttributeNS(null, "ID", true);
        }
        if (entityDescriptor.getValidUntil() != null) {
            this.log.debug("Writting validUntil attribute to EntityDescriptor DOM element");
            String validUntilStr = Configuration.getSAMLDateFormatter().print((ReadableInstant)entityDescriptor.getValidUntil());
            domElement.setAttributeNS(null, "validUntil", validUntilStr);
        }
        if (entityDescriptor.getCacheDuration() != null) {
            this.log.debug("Writting cacheDuration attribute to EntityDescriptor DOM element");
            String cacheDuration = XMLHelper.longToDuration(entityDescriptor.getCacheDuration());
            domElement.setAttributeNS(null, "cacheDuration", cacheDuration);
        }
        for (Map.Entry<QName, String> entry : entityDescriptor.getUnknownAttributes().entrySet()) {
            Attr attribute = XMLHelper.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
            attribute.setValue(entry.getValue());
            domElement.setAttributeNodeNS(attribute);
            if (!Configuration.isIDAttribute(entry.getKey()) && !entityDescriptor.getUnknownAttributes().isIDAttribute(entry.getKey())) continue;
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
    }
}

