/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators.helper;

import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.plugin.rest.jackson.model.UserDto;
import org.squashtest.tm.service.internal.repository.UsersGroupDao;

@Component
public class PartyValidationHelper {
    @Inject
    private UsersGroupDao groupDao;

    public void checkAndAssignValues(Errors errors, UserDto userDto) {
        String groupName = userDto.getGroup().getSimpleName();
        if (groupName.equalsIgnoreCase("admin")) {
            UsersGroup group = this.groupDao.findByQualifiedName("squashtest.authz.group.core.Admin");
            userDto.setGroupId(group.getId());
        } else if (groupName.equalsIgnoreCase("user")) {
            UsersGroup group = this.groupDao.findByQualifiedName("squashtest.authz.group.tm.User");
            userDto.setGroupId(group.getId());
        } else if (groupName.equalsIgnoreCase("testAutomationServer")) {
            UsersGroup group = this.groupDao.findByQualifiedName("squashtest.authz.group.tm.TestAutomationServer");
            userDto.setGroupId(group.getId());
        } else {
            errors.rejectValue("group", "invalid group", "Invalid group value for this user. ");
        }
    }
}

