/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.CheckingAttributeTestStepDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestStepDtoVisitor;
import org.squashtest.tm.plugin.rest.validators.helper.TestStepValidationHelper;

@Component
public class TestStepPostValidator
implements Validator {
    @Inject
    private TestStepValidationHelper testStepValidationHelper;

    public boolean supports(Class<?> clazz) {
        return TestStepDto.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        TestStepDto testStepDto = (TestStepDto)target;
        if (testStepDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing test step, please do a patch request to the test step id. ");
        }
        CheckingAttributeTestStepDtoVisitor visitor = new CheckingAttributeTestStepDtoVisitor(this.testStepValidationHelper, errors);
        try {
            testStepDto.accept(visitor);
        }
        catch (BindException e) {
            e.printStackTrace();
        }
    }

    public void validateRequirements(final long testStepId, final List<Long> requirementIds, final String errorMessage) throws BindException {
        final ArrayList errors = new ArrayList();
        new TestStepDto(){

            @Override
            public void accept(TestStepDtoVisitor testStepDtoVisitor) throws BindException {
                TestStepPostValidator.this.validateRequirementsChecker(testStepDtoVisitor, errors, errorMessage, testStepId, requirementIds);
            }
        };
    }

    private void validateRequirementsChecker(Object obj, List<Errors> errors, String errorMessage, Long testStepId, List<Long> requirementIds) throws BindException {
        BeanPropertyBindingResult validationBean = new BeanPropertyBindingResult(obj, errorMessage);
        this.testStepValidationHelper.checkEntityExist((Errors)validationBean, RestType.TEST_STEP, testStepId);
        for (Long id : requirementIds) {
            this.testStepValidationHelper.checkEntityExist((Errors)validationBean, RestType.REQUIREMENT, id);
        }
        if (validationBean.hasErrors()) {
            errors.add((Errors)validationBean);
        }
        ErrorHandlerHelper.throwIfError(obj, errors, errorMessage);
    }
}

