/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.plugin.rest.jackson.model.PartyDto;
import org.squashtest.tm.plugin.rest.jackson.model.PartyDtoVisitor;
import org.squashtest.tm.plugin.rest.jackson.model.TeamDto;
import org.squashtest.tm.plugin.rest.jackson.model.UserDto;
import org.squashtest.tm.plugin.rest.validators.helper.PartyValidationHelper;

@Component
public class PartyPostValidator
implements Validator {
    @Inject
    private PartyValidationHelper partyValidationHelper;

    public boolean supports(Class<?> clazz) {
        return Party.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, final Errors errors) {
        PartyDto partyDto = (PartyDto)target;
        if (partyDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. ");
        }
        PartyDtoVisitor visitor = new PartyDtoVisitor(){

            @Override
            public void visit(UserDto userDto) {
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"login", (String)"required", (String)"This attribute can't be empty");
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"lastName", (String)"required", (String)"This attribute can't be empty");
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"group", (String)"required", (String)"This attribute can't be empty");
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"password", (String)"required", (String)"This attribute can't be empty");
                PartyPostValidator.this.partyValidationHelper.checkAndAssignValues(errors, userDto);
            }

            @Override
            public void visit(TeamDto teamDto) {
                ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
            }
        };
        partyDto.accept(visitor);
    }
}

