/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import java.util.ArrayList;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.plugin.rest.jackson.model.ParameterDto;
import org.squashtest.tm.plugin.rest.jackson.model.RestType;
import org.squashtest.tm.plugin.rest.jackson.model.TestCaseDto;
import org.squashtest.tm.plugin.rest.validators.helper.ParameterDtoValidationHelper;

@Component
public class ParameterValidator
implements Validator {
    private static final String POST_PARAMETER = "post-parameter";
    private static final String PATCH_PARAMETER = "patch-parameter";
    @Inject
    private ParameterDtoValidationHelper parameterDtoValidationHelper;

    public boolean supports(Class<?> clazz) {
        return Parameter.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        ParameterDto parameterDto = (ParameterDto)target;
        if (parameterDto.getId() != null) {
            errors.rejectValue("id", "generated value", "This attribute is generated by database and should not be provided. If you want to update an existing entity please do a patch request to the resource url.");
        }
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)"required", (String)"This attribute can't be empty");
        TestCaseDto referencedTcDTo = parameterDto.getReferencedTestCase();
        if (!referencedTcDTo.getRestType().equals((Object)RestType.TEST_CASE)) {
            errors.rejectValue("_type", "invalid type", "Type test-case expected");
        } else if (referencedTcDTo.getId() == null) {
            errors.rejectValue("id", "generated value", "The test case id must not be null ");
        }
        this.parameterDtoValidationHelper.checkEntityExist(errors, RestType.TEST_CASE, referencedTcDTo.getId());
    }

    public void validatePostParameter(ParameterDto parameterDto) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)parameterDto, POST_PARAMETER);
        this.validate(parameterDto, (Errors)validation);
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(parameterDto, errors, POST_PARAMETER);
    }

    public void validatePatchParameter(ParameterDto parameterDto, Long parameterId) throws BindException {
        ArrayList<Errors> errors = new ArrayList<Errors>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)parameterDto, PATCH_PARAMETER);
        parameterDto.setId(parameterId);
        this.parameterDtoValidationHelper.checkEntityExist((Errors)validation, RestType.PARAMETER, parameterId);
        if (parameterDto.isHasName()) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)validation, (String)"name", (String)"required", (String)"This attribute can't be empty");
        }
        if (validation.hasErrors()) {
            errors.add((Errors)validation);
        }
        ErrorHandlerHelper.throwIfError(parameterDto, errors, PATCH_PARAMETER);
    }
}

