/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.loader;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

public abstract class AbstractEntityLoader<T> {
    private final String query;
    private final Map<String, Object> parameters;
    private final String countQuery;
    private final EntityManager entityManager;

    protected AbstractEntityLoader(String query, Map<String, Object> parameters, String countQuery, EntityManager entityManager) {
        this.query = query;
        this.parameters = parameters;
        this.countQuery = countQuery;
        this.entityManager = entityManager;
    }

    public Page<T> loadEntityPage(List<String> fields, Pageable pageable) {
        String[] attributes = (String[])fields.stream().filter(this.getAttributes()::containsKey).map(this.getAttributes()::get).collect(Collectors.toCollection(HashSet::new)).toArray(String[]::new);
        EntityGraphQueryBuilder builder = new EntityGraphQueryBuilder(this.entityManager, this.getEntityClass(), this.query).addAttributeNodes(attributes);
        for (Map.Entry<String, String> entry : this.getSubAttributes().entrySet()) {
            if (!fields.contains(entry.getKey())) continue;
            builder.addSubGraph(this.getAttributes().get(entry.getKey()), new String[]{entry.getValue()});
        }
        return builder.executePageable(this.parameters, pageable, this.countQuery);
    }

    protected abstract Map<String, String> getAttributes();

    protected abstract Map<String, String> getSubAttributes();

    protected abstract Class<T> getEntityClass();
}

