/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import java.io.IOException;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequest;

public class TestCaseAutomationPriorityPropertyWriter
extends VirtualBeanPropertyWriter {
    private static final String AUTOMATION_PRIORITY_PROPERTY_LABEL = "automation_priority";

    public TestCaseAutomationPriorityPropertyWriter() {
    }

    private TestCaseAutomationPriorityPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType) {
        super(propDef, contextAnnotations, declaredType);
    }

    protected Object value(Object bean, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        TestCase testCaseHolder = (TestCase)bean;
        Project project = testCaseHolder.getProject();
        if (TestCaseAutomatable.Y.equals((Object)testCaseHolder.getAutomatable()) && project.isAllowAutomationWorkflow()) {
            AutomationRequest automRequest = testCaseHolder.getAutomationRequest();
            if (automRequest.getAutomationPriority() != null) {
                return automRequest.getAutomationPriority();
            }
            jsonGenerator.writeNullField(AUTOMATION_PRIORITY_PROPERTY_LABEL);
            return null;
        }
        return null;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new TestCaseAutomationPriorityPropertyWriter(propDef, declaringClass.getAnnotations(), type);
    }
}

