/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Configurable;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.plugin.rest.jackson.model.RemoteReqInfoRecord;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;

@Configurable
public class RestRequirementSyncInfosPropertyWriter
extends VirtualBeanPropertyWriter {
    @Inject
    RestRequirementVersionService restRequirementVersionService;

    public RestRequirementSyncInfosPropertyWriter() {
    }

    public RestRequirementSyncInfosPropertyWriter(BeanPropertyDefinition propDef, Annotations contextAnnotations, JavaType declaredType, RestRequirementVersionService restRequirementVersionService) {
        super(propDef, contextAnnotations, declaredType);
        this.restRequirementVersionService = restRequirementVersionService;
    }

    protected Object value(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Requirement holder = (Requirement)bean;
        if (holder.isSynchronized()) {
            RemoteReqInfoRecord remoteReqInfo = this.restRequirementVersionService.getRemoteReqInfoByRequirementId(holder.getId());
            gen.writeFieldName("remote_req_id");
            gen.writeString(remoteReqInfo.remoteReqId());
            gen.writeFieldName("remote_req_url");
            gen.writeString(remoteReqInfo.remoteReqUrl());
            gen.writeFieldName("remote_req_perimeter_status");
            gen.writeString(remoteReqInfo.remoteReqPerimeterStatus());
        } else {
            gen.writeFieldName("remote_req_id");
            gen.writeString("null");
            gen.writeFieldName("remote_req_url");
            gen.writeString("null");
            gen.writeFieldName("remote_req_perimeter_status");
            gen.writeString("null");
        }
        return null;
    }

    public VirtualBeanPropertyWriter withConfig(MapperConfig<?> config, AnnotatedClass declaringClass, BeanPropertyDefinition propDef, JavaType type) {
        return new RestRequirementSyncInfosPropertyWriter(propDef, declaringClass.getAnnotations(), type, this.restRequirementVersionService);
    }
}

