/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.TestSuiteDto;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.service.RestTestSuiteService;
import org.squashtest.tm.plugin.rest.validators.TestSuiteValidator;

@RestApiController(value=TestSuite.class)
@UseDefaultRestApiConfiguration
public class RestTestSuiteController
extends BaseRestController {
    public static final String TEST_SUITE_DYNAMIC_FILTER = "*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]";
    @Inject
    private RestTestSuiteService restTestSuiteService;
    @Inject
    private TestSuiteValidator testSuiteValidator;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestIssueService restIssueService;

    @GetMapping(value={"/test-suites/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<EntityModel<TestSuite>> findTestSuite(@PathVariable(value="id") long id) {
        TestSuite testSuite = this.restTestSuiteService.getOne(id);
        EntityModel res = this.toEntityModel((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((EntityModel<TestSuite>)res);
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-suites/{id}/test-plan"})
    @ResponseBody
    @DynamicFilterExpression(value="*, referenced_test_case[name, reference], referenced_dataset[name], iteration[name,reference], executions[execution_status,last_executed_by,last_executed_on], exploratory_session_overview[id,charter,session_duration], -created_on, -created_by, -last_modified_on, -last_modified_by,-iteration")
    public ResponseEntity<PagedModel<EntityModel<IterationTestPlanItem>>> findIterationTestPlan(@PathVariable(value="id") long testSuiteId, Pageable pageable) {
        Page<IterationTestPlanItem> steps = this.restTestSuiteService.findTestPlan(testSuiteId, pageable);
        SingleRelPagedResources res = this.toPagedResourcesWithRel(steps, "test-plan");
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/test-suites"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<EntityModel<TestSuite>> addTestSuite(@RequestBody TestSuiteDto testSuiteDto) throws BindException {
        this.testSuiteValidator.validatePostTestSuite(testSuiteDto);
        TestSuite testSuite = this.restTestSuiteService.addTestSuite(testSuiteDto.getParent().getId(), testSuiteDto);
        EntityModel res = this.toEntityModel((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((EntityModel<TestSuite>)res);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/test-suites/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<EntityModel<TestSuite>> modifyTestSuite(@RequestBody TestSuiteDto testSuiteDto, @PathVariable(value="id") Long testSuiteId) throws BindException {
        this.testSuiteValidator.validatePatchTestSuite(testSuiteDto, testSuiteId);
        TestSuite testSuite = this.restTestSuiteService.modifyTestSuite(testSuiteDto, testSuiteId);
        EntityModel res = this.toEntityModel((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((EntityModel<TestSuite>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/test-suites/{ids}"})
    public ResponseEntity<Void> deleteTestSuite(@PathVariable(value="ids") List<Long> testSuiteIds) {
        this.restTestSuiteService.deleteTestSuite(testSuiteIds);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/test-suites/{testSuiteId}/test-plan/{ids}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<EntityModel<TestSuite>> detachItemFromTestSuite(@PathVariable(value="testSuiteId") Long testSuiteId, @PathVariable(value="ids") List<Long> ids) {
        TestSuite testSuite = this.restTestSuiteService.detachTestPlanFromTestSuite(testSuiteId, ids);
        EntityModel res = this.toEntityModel((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((EntityModel<TestSuite>)res);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/test-suites/{testSuiteId}/test-plan/{ids}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], -path,test_plan[referenced_test_case[name],referenced_dataset[name], execution_status]")
    public ResponseEntity<EntityModel<TestSuite>> attachTestPlanToTestSuite(@PathVariable(value="testSuiteId") Long testSuiteId, @PathVariable(value="ids") List<Long> ids) {
        TestSuite testSuite = this.restTestSuiteService.attachTestPlanToTestSuite(testSuiteId, ids);
        EntityModel res = this.toEntityModel((Identified)testSuite);
        this.linksHelper.addAllLinksForTestSuite((EntityModel<TestSuite>)res);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/test-suites/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="executions[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> findTestSuiteIssues(@PathVariable(value="id") long id, Pageable pageable) {
        List<Long> executionIds = this.restTestSuiteService.getExecutionIdsByTestSuite(id);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(executionIds, pageable);
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }
}

