/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementDto;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.service.RestRequirementVersionService;
import org.squashtest.tm.plugin.rest.service.RestVerifyingTestCaseManagerService;
import org.squashtest.tm.plugin.rest.validators.RequirementValidator;
import org.squashtest.tm.plugin.rest.validators.RequirementVersionValidator;

@RestApiController(value=Requirement.class)
@UseDefaultRestApiConfiguration
public class RestRequirementController
extends BaseRestController {
    @Inject
    private RestRequirementVersionService service;
    @Inject
    private RestVerifyingTestCaseManagerService verifyingTestCaseManager;
    @Inject
    private RequirementValidator requirementValidator;
    @Inject
    private RequirementVersionValidator requirementVersionValidator;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestIssueService restIssueService;

    @GetMapping(value={"/requirements"}, params={"!remote_key", "!server_name"})
    @ResponseBody
    @DynamicFilterExpression(value="name, current_version[reference]")
    public ResponseEntity<PagedModel<EntityModel<Requirement>>> findAllReadable(Pageable pageable) {
        Page<Requirement> reqs = this.service.findAllReadable(pageable);
        PagedModel res = this.toPagedModel(reqs);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/requirements"}, params={"remote_key", "server_name"})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name,version_number]")
    public ResponseEntity<PagedModel<EntityModel<Requirement>>> findSynchronizedRequirement(@RequestParam(value="remote_key") String remoteKey, @RequestParam(value="server_name") String serverName, Pageable pageable) {
        List<Requirement> reqs = this.service.findSynchronizedRequirementsBy(remoteKey, serverName);
        PageImpl pagedReqs = new PageImpl(reqs, pageable, (long)reqs.size());
        PagedModel res = this.toPagedModel((Page)pagedReqs);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/requirements/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name,version_number]")
    @EntityGetter(value={Requirement.class, HighLevelRequirement.class})
    public ResponseEntity<EntityModel<Requirement>> findRequirement(@PathVariable(value="id") long id) {
        Requirement req = this.service.findRequirement(id);
        EntityModel res = this.toEntityModel((Identified)req);
        res.add(this.linkService.createLinkTo((Identified)req.getProject()));
        res.add(this.linkService.createLinkTo((Identified)req.getCurrentVersion(), "current_version"));
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/requirements/{id}/children"})
    @ResponseBody
    @DynamicFilterExpression(value="name, current_version[reference]")
    public ResponseEntity<PagedModel<EntityModel<Requirement>>> findAllReadable(@PathVariable(value="id") long requirementId, Pageable pageable, ContentInclusion include) {
        Page<Requirement> content = null;
        switch (include) {
            case NESTED: {
                content = this.service.findRequirementAllChildren(requirementId, pageable);
                break;
            }
            default: {
                content = this.service.findRequirementChildren(requirementId, pageable);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(content, "children");
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/requirements/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="executions[id], requirements[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDto>>> findRequirementsIssues(@PathVariable(value="id") long id, Pageable pageable) {
        Long requirementVersionId = this.service.findCurrentVersionIdByRequirementId(id);
        List<Long> executionIds = this.service.getExecutionIdsByRequirementVersion(requirementVersionId);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(executionIds, pageable);
        for (IssueDto issue : pagedIssue.getContent()) {
            Set<Execution> executions = issue.getExecutions();
            if (executions == null) continue;
            List allValues = issue.getExecutions().stream().map(execution -> this.service.getRequirementVersionFromIssue(issue.getRemoteIssueId(), execution.getId())).flatMap(Collection::stream).distinct().toList();
            HashSet encounteredIds = new HashSet();
            List<RequirementVersion> filteredList = allValues.stream().filter(reqVer -> encounteredIds.add(reqVer.getId())).toList();
            issue.setRequirements(new HashSet<RequirementVersion>(filteredList));
        }
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/requirements"})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name,version_number]")
    public ResponseEntity<EntityModel<Requirement>> createRequirement(@RequestBody RequirementDto requirementDto) throws BindException {
        this.requirementValidator.validatePostRequirement(requirementDto);
        this.requirementVersionValidator.validateRequirementVersion(requirementDto.getCurrentVersion());
        Requirement req = this.service.createRequirement(requirementDto);
        EntityModel res = this.toEntityModel((Identified)req);
        res.add(this.linkService.createLinkTo((Identified)req.getProject()));
        res.add(this.linkService.createLinkTo((Identified)req.getCurrentVersion(), "current_version"));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/requirements/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name,version_number]")
    public ResponseEntity<EntityModel<Requirement>> modifyRequirement(@RequestBody RequirementDto requirementDto, @PathVariable(value="id") Long requirementId) throws BindException {
        this.requirementValidator.validatePatchRequirement(requirementDto, requirementId);
        this.requirementVersionValidator.validatePatchRequirementVersion(requirementDto.getCurrentVersion(), requirementId);
        Requirement requirement = this.service.modifyRequirement(requirementDto, requirementId);
        EntityModel res = this.toEntityModel((Identified)requirement);
        this.linksHelper.addAllLinksForRequirement((EntityModel<Requirement>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/requirements/{ids}"})
    public ResponseEntity<Void> deleteRequirements(@PathVariable(value="ids") List<Long> reqIds) {
        this.service.deleteRequirements(reqIds);
        return ResponseEntity.noContent().build();
    }

    @ResponseBody
    @PostMapping(value={"/requirements/{id}/coverages/{testCaseIds}"})
    @DynamicFilterExpression(value="*, project[name], parent[name], current_version[*, -requirement, verifying_test_cases[name]], versions[name, version__number]")
    public ResponseEntity<EntityModel<Requirement>> associateTestCases(@PathVariable(value="id") Long requirementId, @PathVariable(value="testCaseIds") List<Long> testCaseIds) throws BindException {
        this.requirementValidator.validateAssociateTestCases(requirementId, testCaseIds);
        Requirement requirement = this.service.findRequirement(requirementId);
        RequirementVersion requirementVersion = requirement.getCurrentVersion();
        this.verifyingTestCaseManager.addVerifyingTestCasesToRequirementVersion(testCaseIds, requirementVersion.getId());
        EntityModel res = this.toEntityModel((Identified)requirement);
        res.add(this.linkService.createLinkTo((Identified)requirement.getProject()));
        res.add(this.linkService.createLinkTo((Identified)requirement.getCurrentVersion(), "current_version"));
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/requirements/{id}/coverages/{testCaseIds}"})
    public ResponseEntity<Void> removeVerifyingTestCasesFromRequirement(@PathVariable(value="id") Long requirementId, @PathVariable(value="testCaseIds") List<Long> testCaseIds) throws BindException {
        this.requirementValidator.validateDisassociateTestCases(requirementId, testCaseIds);
        Long requirementVersionId = this.service.findCurrentVersionIdByRequirementId(requirementId);
        this.verifyingTestCaseManager.removeVerifyingTestCasesToRequirementVersion(testCaseIds, requirementVersionId);
        return ResponseEntity.noContent().build();
    }
}

