/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import javax.inject.Inject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.plugin.rest.controller.RestAbstractExecutionOrderController;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.service.internal.dto.AutomatedTestPlanDTO;
import org.squashtest.tm.service.internal.dto.TriggerRequestDTO;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.testautomation.testplanretriever.CustomFieldValuesForExec;

@UseDefaultRestApiConfiguration
@RestApiController
public class RestExecutionOrderControllerRest
extends RestAbstractExecutionOrderController<TriggerRequestDTO, CustomFieldValuesForExec> {
    @Inject
    private UltimateLicenseAvailabilityService ultimateLicenseService;

    @Override
    @PostMapping(path={"/community-trigger-iteration-automated-test"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<AutomatedTestPlanDTO> triggerIterationExecutionOrder(@RequestBody TriggerRequestDTO triggerRequest) throws BindException {
        if (this.ultimateLicenseService.isAvailable()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
        }
        return this.getIterationResponse(triggerRequest);
    }

    @Override
    @PostMapping(path={"/community-trigger-test-suite-automated-test"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<AutomatedTestPlanDTO> triggerTestSuiteExecutionOrder(@RequestBody TriggerRequestDTO triggerRequest) throws BindException {
        if (this.ultimateLicenseService.isAvailable()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
        }
        return this.getTestSuiteResponse(triggerRequest);
    }
}

