/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaField;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaFieldInfo;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaFieldSchema;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.BugzillaStandardOperation;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.FieldType;

public class Component {
    private static final String ATTACHMENT = "attachment";
    public static final String COMPONENT = "component";
    private static final String ASSIGNEE = "users";
    private int id;
    private List<BugzillaField> nonCustomField;
    private String name;
    private List<BugzillaField> customFields;

    public List<BugzillaField> getNonCustomField() {
        return this.nonCustomField;
    }

    public void setNonCustomField(List<BugzillaField> nonCustomField) {
        this.nonCustomField = nonCustomField;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCustomFields(List<BugzillaField> customFields) {
        this.customFields = customFields;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String toString() {
        return "Component [id=" + this.id + ", nonCustomField=" + this.nonCustomField + ", name=" + this.name + ", customFields=" + this.customFields + "]";
    }

    public Map<String, BugzillaFieldInfo> getFields() {
        ArrayList<BugzillaField> allFields = new ArrayList<BugzillaField>();
        allFields.addAll(this.customFields);
        allFields.addAll(this.nonCustomField);
        HashMap<String, BugzillaFieldInfo> result = new HashMap<String, BugzillaFieldInfo>();
        for (BugzillaField bzField : allFields) {
            result.put(bzField.getName(), this.createField(bzField));
        }
        this.createAttachementField(result);
        return result;
    }

    private void createAttachementField(Map<String, BugzillaFieldInfo> result) {
        HashSet<BugzillaStandardOperation> operationAttach = new HashSet<BugzillaStandardOperation>();
        BugzillaFieldSchema attachmentFieldSchema = new BugzillaFieldSchema("array", ATTACHMENT, ATTACHMENT, null, null);
        BugzillaFieldInfo attachmentFieldInfo = new BugzillaFieldInfo(ATTACHMENT, false, ATTACHMENT, operationAttach, attachmentFieldSchema, null);
        result.put(ATTACHMENT, attachmentFieldInfo);
    }

    private BugzillaFieldInfo createField(BugzillaField bzField) {
        HashSet<BugzillaStandardOperation> operations = new HashSet<BugzillaStandardOperation>();
        operations.add(BugzillaStandardOperation.SET);
        String fieldType = this.debugFieldType(bzField);
        BugzillaFieldSchema fieldSchema = new BugzillaFieldSchema(bzField.getType().toString(), null, fieldType, null, null);
        BugzillaFieldInfo fieldInfo = new BugzillaFieldInfo(bzField.getName(), bzField.isMandatory(), bzField.getLabel(), operations, fieldSchema, bzField.getPossibleValues());
        return fieldInfo;
    }

    private String debugFieldType(BugzillaField bzField) {
        String result;
        if ("version".equals(bzField.getName()) || "target_milestone".equals(bzField.getName())) {
            result = FieldType.DROP_DOWN.toString();
        } else if ("assigned_to".equals(bzField.getName())) {
            result = ASSIGNEE;
        } else if ("longdesc".equals(bzField.getName())) {
            result = FieldType.LARGE_TEXT_BOX.toString();
            bzField.setName("description");
        } else {
            result = "short_desc".equals(bzField.getName()) ? FieldType.FREE_TEXT.toString() : bzField.getType().toString();
        }
        return result;
    }
}

