/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.bugzilla.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.BugzillaBugTrackerInterfaceDescriptor;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.BugzillaClient;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.command.DelegateCommands;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.converter.BugzillaEntityConverter;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.exception.BugzillaExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Bug;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.Product;
import org.squashtest.tm.plugin.bugtracker.bugzilla.internal.xmlrcp.client.domain.User;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;

@Component
@Scope(value="prototype")
public class BugzillaConnector
implements AdvancedBugTrackerConnector {
    private static final String ISSUE_URL_SUFFIX = "/show_bug.cgi?id=";
    private BugTracker bugTracker;
    @Inject
    private BugzillaBugTrackerInterfaceDescriptor interfaceDescriptor;
    @Inject
    private BugzillaEntityConverter converter;
    @Inject
    private BugzillaClient client;
    @Inject
    private BugzillaExceptionHandler bugzillaExceptionHandler;

    public void setBugTracker(BugTracker bugTracker) {
        this.bugTracker = bugTracker;
    }

    public void authenticate(Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        if (!AuthenticationProtocol.BASIC_AUTH.equals((Object)credentials.getImplementedProtocol())) {
            throw new IllegalArgumentException("Expected BasicAuth credentials.");
        }
        this.client.init(this.bugTracker, (BasicAuthenticationCredentials)credentials);
    }

    public void checkCredentials(Credentials credentials) throws BugTrackerNoCredentialsException, BugTrackerRemoteException {
        this.authenticate(credentials);
        this.checkCredentials();
    }

    private void checkCredentials() {
        this.client.getBugzillaVersion();
    }

    public URL makeViewIssueUrl(String issueId) {
        String strUrl = String.valueOf(this.bugTracker.getUrl().replaceAll("\\/$", "")) + ISSUE_URL_SUFFIX + issueId;
        try {
            return new URL(strUrl);
        }
        catch (MalformedURLException e) {
            throw this.bugzillaExceptionHandler.genericError(e);
        }
    }

    public AdvancedProject findProject(String projectName) throws ProjectNotFoundException, BugTrackerRemoteException {
        Product product = this.client.findProjectForCreateByName(projectName);
        return this.converter.bugzilla2SquashProject(product);
    }

    public AdvancedProject findProjectById(String projectId) throws ProjectNotFoundException, BugTrackerRemoteException {
        Integer projectIdAsInt = Integer.valueOf(projectId);
        Product product = this.client.findProjectForCreateById(projectIdAsInt);
        return this.converter.bugzilla2SquashProject(product);
    }

    public AdvancedIssue createIssue(RemoteIssue issue) throws BugTrackerRemoteException {
        AdvancedIssue advancedIssue = (AdvancedIssue)issue;
        String projectKey = advancedIssue.getProject().getId();
        Product project = this.client.findProjectForCreateById(Integer.parseInt(projectKey));
        Bug inputIssue = this.converter.squash2bugzillaIssue(advancedIssue, project);
        this.client.verifyAssigneAssignable(inputIssue);
        Bug createdIssue = this.client.createIssue(inputIssue);
        Bug bugzillaIssue = this.client.getIssue(createdIssue.getId().toString());
        return this.converter.bugzilla2squashIssue(bugzillaIssue);
    }

    public void linkIssues(String remoteIssueKey, List<String> remoteReqIds) {
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        return this.interfaceDescriptor;
    }

    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context) {
        AdvancedProject project = this.findProject(projectName);
        Object object = project.getSchemeMap().keySet().iterator().next();
        String key = object.toString();
        Collection fields = project.getFieldScheme(key);
        AdvancedIssue issue = new AdvancedIssue();
        issue.setProject(project);
        issue.setBugtracker(this.bugTracker.getName());
        issue.setCurrentScheme(key);
        for (Field field : fields) {
            issue.setFieldValue(field.getId(), null);
            switch (field.getId()) {
                case "attachment": {
                    field.setLabel(this.interfaceDescriptor.getAttachmentLabel());
                    break;
                }
                case "assigned_to": {
                    field.setLabel(this.interfaceDescriptor.getReportAssigneeLabel());
                    break;
                }
                case "rep_platform": {
                    field.setLabel(this.interfaceDescriptor.getPlatformLabel());
                }
            }
        }
        return issue;
    }

    public AdvancedIssue findIssue(String issueKey) {
        Bug issue = this.client.getIssue(issueKey);
        AdvancedIssue advancedIssue = this.converter.bugzilla2squashIssue(issue);
        String schemeName = advancedIssue.getCurrentScheme();
        AdvancedProject project = this.converter.createReadOnlyProjectStub(schemeName, this.interfaceDescriptor);
        project.setId(String.valueOf(issue.getProduct().getId()));
        project.setName(issue.getProduct().getName());
        advancedIssue.setProject(project);
        return advancedIssue;
    }

    public List<AdvancedIssue> findIssues(List<String> issueKeys) {
        List<Bug> issueList = this.client.getIssues(issueKeys);
        return this.converter.bugzilla2SquashIssues(issueList);
    }

    public void forwardAttachments(String remoteIssueKey, List<Attachment> attachments) {
        this.client.forwardAttachments(remoteIssueKey, attachments);
    }

    public Object executeDelegateCommand(DelegateCommand command) {
        FieldValue fieldValue = null;
        if (DelegateCommands.isSearchAssignableCommand(command)) {
            List<User> users = this.client.getAssignableUser((String)command.getArgument());
            fieldValue = this.converter.convertToUserCompositeFieldValue(users);
        } else {
            fieldValue = new FieldValue();
        }
        return fieldValue;
    }
}

