/*
 * Decompiled with CFR 0.152.
 */
package bugzilla.org.apache.xmlrpc.util;

import bugzilla.org.apache.ws.commons.util.Base64;
import bugzilla.org.apache.xmlrpc.common.XmlRpcHttpRequestConfigImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class HttpUtil {
    public static String encodeBasicAuthentication(String pUser, String pPassword, String pEncoding) throws UnsupportedEncodingException {
        if (pUser == null) {
            return null;
        }
        String s = pUser + ':' + pPassword;
        if (pEncoding == null) {
            pEncoding = "UTF-8";
        }
        byte[] bytes = s.getBytes(pEncoding);
        return Base64.encode(s.getBytes(pEncoding), 0, bytes.length, 0, null);
    }

    public static boolean isUsingGzipEncoding(String pHeaderValue) {
        if (pHeaderValue == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(pHeaderValue, ",");
        while (st.hasMoreTokens()) {
            String encoding = st.nextToken();
            int offset = encoding.indexOf(59);
            if (offset >= 0) {
                encoding = encoding.substring(0, offset);
            }
            if (!"gzip".equalsIgnoreCase(encoding.trim())) continue;
            return true;
        }
        return false;
    }

    public static String getNonIdentityTransferEncoding(String pHeaderValue) {
        if (pHeaderValue == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(pHeaderValue, ",");
        while (st.hasMoreTokens()) {
            String encoding = st.nextToken();
            int offset = encoding.indexOf(59);
            if (offset >= 0) {
                encoding = encoding.substring(0, offset);
            }
            if ("identity".equalsIgnoreCase(encoding.trim())) continue;
            return encoding.trim();
        }
        return null;
    }

    public static boolean isUsingGzipEncoding(Enumeration pValues) {
        if (pValues != null) {
            while (pValues.hasMoreElements()) {
                if (!HttpUtil.isUsingGzipEncoding((String)pValues.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public static String readLine(InputStream pIn, byte[] pBuffer) throws IOException {
        int next;
        int count = 0;
        while ((next = pIn.read()) >= 0 && next != 10) {
            if (next != 13) {
                pBuffer[count++] = (byte)next;
            }
            if (count < pBuffer.length) continue;
            throw new IOException("HTTP Header too long");
        }
        return new String(pBuffer, 0, count, "US-ASCII");
    }

    public static void parseAuthorization(XmlRpcHttpRequestConfigImpl pConfig, String pLine) {
        if (pLine == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(pLine = pLine.trim());
        if (!st.hasMoreTokens()) {
            return;
        }
        String type = st.nextToken();
        if (!"basic".equalsIgnoreCase(type)) {
            return;
        }
        if (!st.hasMoreTokens()) {
            return;
        }
        String auth = st.nextToken();
        try {
            String str;
            int col;
            byte[] c = Base64.decode(auth.toCharArray(), 0, auth.length());
            String enc = pConfig.getBasicEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            if ((col = (str = new String(c, enc)).indexOf(58)) >= 0) {
                pConfig.setBasicUserName(str.substring(0, col));
                pConfig.setBasicPassword(str.substring(col + 1));
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
    }
}

