/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.legacybooks.testcases.query;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.CufBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.Dataset;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.DatasetParamValue;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.LinkedRequirementsBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.NodeBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.Parameter;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.TestCaseBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.beans.TestCaseStepsBean;
import org.squashtest.tm.plugin.report.legacybooks.testcases.foundation.CufType;

public class TestCasesTreeFormatter {
    private static final String END_SEPARATOR_PLACEHOLDER = "=Sep=";
    private static final String SORTING_CHAIN_SEPARATOR = " ";
    private static final String CHAIN_SEPARATOR = " > ";
    private static final String SEPARATOR_PLACEHOLDER = "=Sep=,";
    private static final String TAG_EMPTY = "";
    private static final String TAG_SEPARATOR = " | ";
    private static final Integer POSITION = 1;
    private static final String MILESTONE_SEPARATOR = ", ";
    private List<Integer> paragraphs;
    private List<Long> tcIdsAlreadyAdd;
    private Long projectId;

    public Collection<TestCaseStepsBean> toTestCaseSteps(Collection<Object[]> testCaseStepsData) {
        ArrayList<TestCaseStepsBean> result = new ArrayList<TestCaseStepsBean>();
        for (Object[] array : testCaseStepsData) {
            TestCaseStepsBean testCaseStepsBean = new TestCaseStepsBean();
            testCaseStepsBean.setId(this.evaluateExpressionToLong(array[0]));
            testCaseStepsBean.setAction(this.evaluateExpressionToString(array[1]));
            testCaseStepsBean.setExpectedResult(this.evaluateExpressionToString(array[2]));
            testCaseStepsBean.setType(this.evaluateExpressionToString(array[3]));
            testCaseStepsBean.setOrder(this.evaluateExpressionToLong(array[4]));
            testCaseStepsBean.setDataset(this.evaluateExpressionToString(array[5]));
            testCaseStepsBean.setTestCaseId(this.evaluateExpressionToLong(array[6]));
            testCaseStepsBean.setDelegateParameterValues(this.evaluateExpressionToBoolean(array[7]));
            result.add(testCaseStepsBean);
        }
        return result;
    }

    public Collection<CufBean> toCufBean(Collection<Object[]> cufsData) {
        ArrayList<CufBean> result = new ArrayList<CufBean>();
        for (Object[] array : cufsData) {
            CufBean cufBean = new CufBean();
            cufBean.setValue(this.evaluateExpressionToString(array[0]));
            cufBean.setLabel(this.evaluateExpressionToString(array[1]));
            cufBean.setType(this.evaluateExpressionToString(array[2]));
            cufBean.setEntityId(this.evaluateExpressionToLong(array[3]));
            result.add(cufBean);
        }
        return result;
    }

    Collection<CufBean> toTagCufBean(Collection<Object[]> tagCufData) {
        ArrayList<CufBean> cufs = new ArrayList<CufBean>();
        for (Object[] row : tagCufData) {
            CufBean cuf = new CufBean();
            if (row[0] != null) {
                String chain = this.evaluateExpressionToString(row[0]).replaceAll(SEPARATOR_PLACEHOLDER, TAG_SEPARATOR);
                cuf.setValue(this.evaluateExpressionToString(chain.substring(0, chain.length() - END_SEPARATOR_PLACEHOLDER.length())));
            } else {
                cuf.setValue(TAG_EMPTY);
            }
            cuf.setLabel(this.evaluateExpressionToString(row[1]));
            cuf.setType(this.evaluateExpressionToString(row[2]));
            cuf.setEntityId(this.evaluateExpressionToLong(row[3]));
            cufs.add(cuf);
        }
        return cufs;
    }

    public Collection<LinkedRequirementsBean> toLinkedRequirementBean(Collection<Object[]> linkedRequirementData) {
        ArrayList<LinkedRequirementsBean> result = new ArrayList<LinkedRequirementsBean>();
        for (Object[] array : linkedRequirementData) {
            LinkedRequirementsBean linkedRequirementsBean = new LinkedRequirementsBean();
            linkedRequirementsBean.setId(this.evaluateExpressionToLong(array[0]));
            linkedRequirementsBean.setName(this.evaluateExpressionToString(array[1]));
            linkedRequirementsBean.setProjectName(this.evaluateExpressionToString(array[2]));
            linkedRequirementsBean.setCriticality(this.evaluateExpressionToString(array[3]));
            linkedRequirementsBean.setVersion(this.evaluateExpressionToLong(array[4]));
            linkedRequirementsBean.setReference(this.evaluateExpressionToString(array[5]));
            linkedRequirementsBean.setTestCaseId(this.evaluateExpressionToLong(array[6]));
            result.add(linkedRequirementsBean);
        }
        return result;
    }

    public Collection<TestCaseBean> toTestCaseBean(Collection<Object[]> testCaseData, boolean printSteps) {
        ArrayList<TestCaseBean> result = new ArrayList<TestCaseBean>();
        for (Object[] array : testCaseData) {
            TestCaseBean testcase = new TestCaseBean();
            String chain = this.evaluateExpressionToString(array[0]).replaceAll(SEPARATOR_PLACEHOLDER, CHAIN_SEPARATOR);
            testcase.setChain(HtmlUtils.htmlEscape((String)chain.substring(0, chain.length() - END_SEPARATOR_PLACEHOLDER.length())));
            testcase.setId(this.evaluateExpressionToLong(array[1]));
            testcase.setFolder(this.evaluateExpressionToLong(array[2]));
            testcase.setName(HtmlUtils.htmlEscape((String)this.evaluateExpressionToString(array[3])));
            testcase.setLevel(this.evaluateExpressionToLong(array[4]));
            testcase.setImportance(this.evaluateExpressionToString(array[5]));
            testcase.setNature(this.evaluateExpressionToString(array[6]));
            testcase.setType(this.evaluateExpressionToString(array[7]));
            testcase.setNatureType(this.evaluateExpressionToString(array[8]));
            testcase.setTypeType(this.evaluateExpressionToString(array[9]));
            testcase.setStatus(this.evaluateExpressionToString(array[10]));
            testcase.setExecutionMode(this.evaluateExpressionToLong(array[11]));
            testcase.setPrerequisites(this.evaluateExpressionToString(array[12]));
            testcase.setReference(HtmlUtils.htmlEscape((String)this.evaluateExpressionToString(array[13])));
            testcase.setCreatedOn(this.evaluateExpressionToString(array[14]));
            testcase.setCreatedBy(this.evaluateExpressionToString(array[15]));
            testcase.setLastModifiedOn(this.evaluateExpressionToString(array[16]));
            testcase.setLastModifiedBy(this.evaluateExpressionToString(array[17]));
            testcase.setDescription(this.evaluateExpressionToString(array[18]));
            testcase.setAttachments(this.evaluateExpressionToLong(array[19]));
            String sortingChain = this.evaluateExpressionToString(array[20]).replaceAll(SEPARATOR_PLACEHOLDER, SORTING_CHAIN_SEPARATOR);
            testcase.setSortingChain(HtmlUtils.htmlEscape((String)sortingChain.substring(0, sortingChain.length() - END_SEPARATOR_PLACEHOLDER.length())));
            String milestoneLabels = this.evaluateExpressionToString(array[21]).replace(",", MILESTONE_SEPARATOR);
            testcase.setMilestoneLabels(milestoneLabels);
            String nodeIds = this.evaluateExpressionToString(array[22]);
            String[] nodesIds = nodeIds.split(SEPARATOR_PLACEHOLDER);
            ArrayList<Long> hierachyNodes = new ArrayList<Long>();
            String[] stringArray = nodesIds;
            int n = nodesIds.length;
            int n2 = 0;
            while (n2 < n) {
                String node = stringArray[n2];
                hierachyNodes.add(Long.parseLong(node.replace(END_SEPARATOR_PLACEHOLDER, TAG_EMPTY)));
                ++n2;
            }
            testcase.setNodeIds(hierachyNodes);
            String script = this.evaluateExpressionToString(array[23]);
            script = script.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll(SORTING_CHAIN_SEPARATOR, "&nbsp;").replaceAll("\\t", "&nbsp;&nbsp;").replaceAll("\\n", "<br/>");
            testcase.setScript(script);
            testcase.setAllowAutomationWorkflow(this.evaluateExpressionToLong(array[24]));
            testcase.setAutomatable(this.evaluateExpressionToString(array[25]));
            testcase.setRequestStatus(this.evaluateExpressionToString(array[26]));
            testcase.setAutomationPriority(this.evaluateExpressionToString(array[27]));
            testcase.setPrintSteps(printSteps);
            result.add(testcase);
        }
        return result;
    }

    Collection<NodeBean> toNodesBean(Collection<Object[]> nodesData) {
        ArrayList<NodeBean> nodeBeans = new ArrayList<NodeBean>();
        for (Object[] array : nodesData) {
            NodeBean nodeBean = new NodeBean();
            nodeBean.setProjectId(this.evaluateExpressionToLong(array[0]));
            nodeBean.setProjectName(this.evaluateExpressionToString(array[1]));
            nodeBean.setItemId(this.evaluateExpressionToLong(array[2]));
            nodeBeans.add(nodeBean);
        }
        return nodeBeans;
    }

    Collection<TestCaseStepsBean> toCallStepBean(Collection<Object[]> objects, Long idTestCase) {
        ArrayList<TestCaseStepsBean> result = new ArrayList<TestCaseStepsBean>();
        for (Object[] array : objects) {
            TestCaseStepsBean testCaseStepsBean = new TestCaseStepsBean();
            testCaseStepsBean.setId(this.evaluateExpressionToLong(array[0]));
            testCaseStepsBean.setAction(this.evaluateExpressionToString(array[1]));
            testCaseStepsBean.setExpectedResult(this.evaluateExpressionToString(array[2]));
            testCaseStepsBean.setType(this.evaluateExpressionToString(array[3]));
            testCaseStepsBean.setOrder(this.evaluateExpressionToLong(array[4]));
            testCaseStepsBean.setDataset(this.evaluateExpressionToString(array[5]));
            testCaseStepsBean.setTestCaseId(idTestCase);
            result.add(testCaseStepsBean);
        }
        return result;
    }

    Collection<Parameter> toParameter(Collection<Object[]> objects) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Object[] array : objects) {
            Parameter parameter = new Parameter();
            parameter.setName(this.evaluateExpressionToString(array[0]));
            parameter.setDescription(this.evaluateExpressionToString(array[1]));
            parameter.setTestCaseId(this.evaluateExpressionToLong(array[2]));
            parameter.setTestCaseSourceName(this.evaluateExpressionToString(array[3]));
            parameter.setTestCaseSourceRef(this.evaluateExpressionToString(array[4]));
            parameter.setTestCaseSourceProjectName(this.evaluateExpressionToString(array[5]));
            parameters.add(parameter);
        }
        return parameters;
    }

    Collection<Dataset> toDataSet(Collection<Object[]> objects) {
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        for (Object[] array : objects) {
            Dataset dataset = new Dataset();
            dataset.setId(this.evaluateExpressionToLong(array[0]));
            dataset.setName(this.evaluateExpressionToString(array[1]));
            dataset.setTestCaseId(this.evaluateExpressionToLong(array[2]));
            datasets.add(dataset);
        }
        return datasets;
    }

    Collection<DatasetParamValue> toDataSetParamValue(Collection<Object[]> objects) {
        ArrayList<DatasetParamValue> datasetParamValues = new ArrayList<DatasetParamValue>();
        for (Object[] array : objects) {
            DatasetParamValue datasetParamValue = new DatasetParamValue();
            datasetParamValue.setDataSetId(this.evaluateExpressionToLong(array[0]));
            datasetParamValue.setName(this.evaluateExpressionToString(array[1]));
            datasetParamValue.setValue(this.evaluateExpressionToString(array[2]));
            datasetParamValues.add(datasetParamValue);
        }
        return datasetParamValues;
    }

    public void bindAll(Collection<TestCaseStepsBean> testCaseStepsBeans, Map<String, Collection<CufBean>> testCaseCufMap, Map<String, Collection<CufBean>> stepCufMap, Collection<LinkedRequirementsBean> linkedRequirementsBeans, Collection<TestCaseBean> testCaseBeans, Collection<Parameter> parameters, Collection<Dataset> datasets, Collection<DatasetParamValue> datasetParamValues, Collection<NodeBean> nodes) {
        this.tcIdsAlreadyAdd = new ArrayList<Long>();
        this.paragraphs = new ArrayList<Integer>();
        this.projectId = null;
        if (!testCaseStepsBeans.isEmpty()) {
            this.bindCufToStep(testCaseStepsBeans, stepCufMap.get(CufType.CUFS.getValue()));
            this.bindNumCufToStep(testCaseStepsBeans, stepCufMap.get(CufType.NUM_CUFS.getValue()));
            this.bindTagCufToStep(testCaseStepsBeans, stepCufMap.get(CufType.TAG_CUFS.getValue()));
            this.bindRtfCufToStep(testCaseStepsBeans, stepCufMap.get(CufType.RTF_CUFS.getValue()));
            this.bindTestStepToTestCase(testCaseBeans, testCaseStepsBeans);
        }
        this.bindParamValuesToDataset(datasets, datasetParamValues);
        this.bindDatasetToTestCase(datasets, testCaseBeans);
        this.bindCufToTestCase(testCaseBeans, testCaseCufMap.get(CufType.CUFS.getValue()));
        this.bindNumCufToTestCase(testCaseBeans, testCaseCufMap.get(CufType.NUM_CUFS.getValue()));
        this.bindTagCufTestCase(testCaseBeans, testCaseCufMap.get(CufType.TAG_CUFS.getValue()));
        this.bindRtfCufToTestCase(testCaseBeans, testCaseCufMap.get(CufType.RTF_CUFS.getValue()));
        this.bindParameterForTestCase(testCaseBeans, parameters);
        if (!linkedRequirementsBeans.isEmpty()) {
            this.bindLinkedReqToTc(testCaseBeans, linkedRequirementsBeans);
        }
        this.bindTestCaseToNode(testCaseBeans, nodes);
    }

    private void bindTestCaseToNode(Collection<TestCaseBean> testCaseBeans, Collection<NodeBean> nodeBeans) {
        for (NodeBean nodeBean : nodeBeans) {
            List<TestCaseBean> testCaseBeans1 = this.groupTestCaseForNode(testCaseBeans, nodeBean);
            nodeBean.setTestCasesBeans(testCaseBeans1);
        }
    }

    private void bindTestStepToTestCase(Collection<TestCaseBean> testCaseBeans, Collection<TestCaseStepsBean> testCaseStepsBeans) {
        for (TestCaseBean testCaseBean : testCaseBeans) {
            List<TestCaseStepsBean> testCaseStepBeanList = this.groupTestStepForTestCase(testCaseStepsBeans, testCaseBean);
            testCaseBean.setTcStepsBeans(testCaseStepBeanList);
        }
    }

    private void bindLinkedReqToTc(Collection<TestCaseBean> testCaseBeans, Collection<LinkedRequirementsBean> linkedRequirementsBeans) {
        for (TestCaseBean testCaseBean : testCaseBeans) {
            List<LinkedRequirementsBean> linkedRequirementsBeanList = this.groupLinkedRequirementForTestCase(linkedRequirementsBeans, testCaseBean);
            testCaseBean.setLinkedRequirements(linkedRequirementsBeanList);
        }
    }

    private void bindCufToStep(Collection<TestCaseStepsBean> testCaseStepsBeans, Collection<CufBean> cufBeans) {
        for (TestCaseStepsBean testCaseStepsBean : testCaseStepsBeans) {
            List<CufBean> cufs = this.groupCufsForTestSteps(cufBeans, testCaseStepsBean);
            testCaseStepsBean.setCufs(cufs);
        }
    }

    private void bindNumCufToStep(Collection<TestCaseStepsBean> testCaseStepsBeans, Collection<CufBean> cufBeans) {
        for (TestCaseStepsBean testCaseStepsBean : testCaseStepsBeans) {
            List<CufBean> cufs = this.groupCufsForTestSteps(cufBeans, testCaseStepsBean);
            testCaseStepsBean.setNumCufs(cufs);
        }
    }

    private void bindTagCufToStep(Collection<TestCaseStepsBean> testCaseStepsBeans, Collection<CufBean> cufBeans) {
        for (TestCaseStepsBean testCaseStepsBean : testCaseStepsBeans) {
            List<CufBean> cufs = this.groupCufsForTestSteps(cufBeans, testCaseStepsBean);
            testCaseStepsBean.setTagCufs(cufs);
        }
    }

    private void bindRtfCufToStep(Collection<TestCaseStepsBean> testCaseStepsBeans, Collection<CufBean> cufBeans) {
        for (TestCaseStepsBean testCaseStepsBean : testCaseStepsBeans) {
            List<CufBean> cufs = this.groupCufsForTestSteps(cufBeans, testCaseStepsBean);
            testCaseStepsBean.setRtfCufs(cufs);
        }
    }

    private void bindParameterForTestCase(Collection<TestCaseBean> testCases, Collection<Parameter> parameters) {
        for (TestCaseBean testCase : testCases) {
            List<Parameter> params = this.groupParameterForTestCase(parameters, testCase);
            testCase.setParameters(params);
        }
    }

    private void bindParamValuesToDataset(Collection<Dataset> datasets, Collection<DatasetParamValue> datasetParamValues) {
        for (Dataset dataset : datasets) {
            List<DatasetParamValue> paramValues = this.groupParamValueToDataset(datasetParamValues, dataset);
            dataset.setDatasetParamValues(paramValues);
        }
    }

    private void bindDatasetToTestCase(Collection<Dataset> datasets, Collection<TestCaseBean> testCases) {
        for (TestCaseBean testCase : testCases) {
            List<Dataset> datasetList = this.groupDatasetToTestCase(datasets, testCase);
            testCase.setDatasets(datasetList);
        }
    }

    private void bindCufToTestCase(Collection<TestCaseBean> testCaseBeans, Collection<CufBean> cufBeans) {
        for (TestCaseBean testCaseBean : testCaseBeans) {
            List<CufBean> cufs = this.groupCufsForTestCases(cufBeans, testCaseBean);
            testCaseBean.setCufs(cufs);
        }
    }

    private void bindNumCufToTestCase(Collection<TestCaseBean> testCaseBeans, Collection<CufBean> cufBeans) {
        for (TestCaseBean testCaseBean : testCaseBeans) {
            List<CufBean> cufs = this.groupCufsForTestCases(cufBeans, testCaseBean);
            testCaseBean.setNumCufs(cufs);
        }
    }

    private void bindTagCufTestCase(Collection<TestCaseBean> testCaseBeans, Collection<CufBean> cufBeans) {
        for (TestCaseBean testCaseBean : testCaseBeans) {
            List<CufBean> cufs = this.groupCufsForTestCases(cufBeans, testCaseBean);
            testCaseBean.setTagCufs(cufs);
        }
    }

    private void bindRtfCufToTestCase(Collection<TestCaseBean> testCaseBeans, Collection<CufBean> cufBeans) {
        for (TestCaseBean testCaseBean : testCaseBeans) {
            List<CufBean> cufs = this.groupCufsForTestCases(cufBeans, testCaseBean);
            testCaseBean.setRtfCufs(cufs);
        }
    }

    public List<CufBean> groupCufsForTestCases(Collection<CufBean> cufData, TestCaseBean testCaseBean) {
        ArrayList<CufBean> cufs = new ArrayList<CufBean>();
        for (CufBean cufBean : cufData) {
            if (!testCaseBean.acceptAsCuf(cufBean)) continue;
            cufs.add(cufBean);
        }
        return cufs;
    }

    public List<TestCaseBean> groupTestCaseForNode(Collection<TestCaseBean> testCaseBeans, NodeBean nodeBean) {
        Iterator<TestCaseBean> iterator = testCaseBeans.iterator();
        ArrayList<TestCaseBean> tc = new ArrayList<TestCaseBean>();
        HashSet<Long> tcIds = new HashSet<Long>();
        while (iterator.hasNext()) {
            TestCaseBean next = iterator.next();
            if (!next.getNodeIds().contains(nodeBean.getItemId())) continue;
            tcIds.addAll(next.getNodeIds());
        }
        for (TestCaseBean testCaseBean : testCaseBeans) {
            if (!tcIds.contains(testCaseBean.getId()) || this.tcIdsAlreadyAdd.contains(testCaseBean.getId())) continue;
            if (testCaseBean.isAFolder()) {
                this.changeParagraph(testCaseBean, nodeBean);
            }
            testCaseBean.setParagraph(this.paragraphs);
            tc.add(testCaseBean);
            this.tcIdsAlreadyAdd.add(testCaseBean.getId());
        }
        return tc;
    }

    public List<Parameter> groupParameterForTestCase(Collection<Parameter> parameters, TestCaseBean testCase) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Parameter param : parameters) {
            if (!testCase.getId().equals(param.getTestCaseId())) continue;
            params.add(param);
        }
        return params;
    }

    private List<DatasetParamValue> groupParamValueToDataset(Collection<DatasetParamValue> datasetParamValues, Dataset dataset) {
        ArrayList<DatasetParamValue> result = new ArrayList<DatasetParamValue>();
        for (DatasetParamValue datasetParamValue : datasetParamValues) {
            if (!dataset.getId().equals(datasetParamValue.getDataSetId())) continue;
            result.add(datasetParamValue);
        }
        return result;
    }

    private List<Dataset> groupDatasetToTestCase(Collection<Dataset> datasets, TestCaseBean testCase) {
        ArrayList<Dataset> result = new ArrayList<Dataset>();
        for (Dataset dataset : datasets) {
            if (!dataset.getTestCaseId().equals(testCase.getId())) continue;
            result.add(dataset);
        }
        return result;
    }

    private void changeParagraph(TestCaseBean testCaseBean, NodeBean nodeBean) {
        if (this.projectId != null && !this.projectId.equals(nodeBean.getProjectId())) {
            this.paragraphs = new ArrayList<Integer>();
        }
        this.projectId = nodeBean.getProjectId();
        if (testCaseBean.getLevel() + (long)POSITION.intValue() > (long)this.paragraphs.size()) {
            this.paragraphs.add(POSITION);
        } else if (testCaseBean.getLevel() + (long)POSITION.intValue() == (long)this.paragraphs.size()) {
            int index = testCaseBean.getLevel().intValue();
            int value = this.paragraphs.get(index) + POSITION;
            this.paragraphs.set(index, value);
        } else if (testCaseBean.getLevel() + (long)POSITION.intValue() < (long)this.paragraphs.size()) {
            int index = testCaseBean.getLevel().intValue();
            int value = this.paragraphs.get(index) + POSITION;
            this.paragraphs.set(index, value);
            this.paragraphs.subList(index + POSITION, this.paragraphs.size()).clear();
        }
    }

    private List<TestCaseStepsBean> groupTestStepForTestCase(Collection<TestCaseStepsBean> testCaseStepsBeans, TestCaseBean testCaseBean) {
        ArrayList<TestCaseStepsBean> tc = new ArrayList<TestCaseStepsBean>();
        for (TestCaseStepsBean testCaseStepsBean : testCaseStepsBeans) {
            if (!testCaseBean.getId().equals(testCaseStepsBean.getTestCaseId())) continue;
            tc.add(testCaseStepsBean);
        }
        return tc;
    }

    private List<LinkedRequirementsBean> groupLinkedRequirementForTestCase(Collection<LinkedRequirementsBean> linkedRequirementsBeans, TestCaseBean testCaseBean) {
        ArrayList<LinkedRequirementsBean> linkedRequirementsBeanArrayList = new ArrayList<LinkedRequirementsBean>();
        for (LinkedRequirementsBean linkedRequirementsBean : linkedRequirementsBeans) {
            if (!testCaseBean.getId().equals(linkedRequirementsBean.getTestCaseId())) continue;
            linkedRequirementsBeanArrayList.add(linkedRequirementsBean);
        }
        return linkedRequirementsBeanArrayList;
    }

    private List<CufBean> groupCufsForTestSteps(Collection<CufBean> cufData, TestCaseStepsBean testCaseStepsBean) {
        ArrayList<CufBean> cufs = new ArrayList<CufBean>();
        for (CufBean cuf : cufData) {
            if (!testCaseStepsBean.acceptAsCuf(cuf)) continue;
            cufs.add(cuf);
        }
        return cufs;
    }

    private Locale currentLocale() {
        Locale current = LocaleContextHolder.getLocale();
        if (current == null) {
            current = Locale.getDefault();
        }
        return current;
    }

    private String convertDatetoString(Date date) {
        return DateFormat.getDateTimeInstance(3, 3, this.currentLocale()).format(date);
    }

    private String evaluateExpressionToString(Object obj) {
        if (obj instanceof Date) {
            return obj != null ? this.convertDatetoString((Date)obj) : TAG_EMPTY;
        }
        return obj != null ? obj.toString() : TAG_EMPTY;
    }

    protected Long evaluateExpressionToLong(Object obj) {
        return Long.valueOf(obj.toString());
    }

    protected Boolean evaluateExpressionToBoolean(Object obj) {
        return Boolean.parseBoolean(obj.toString());
    }
}

