/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.synchronisation.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.synchronisation.SynchronisationStatus;
import org.squashtest.tm.domain.testautomation.AutomatedTest;
import org.squashtest.tm.domain.testcase.GetKindTestCaseVisitor;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.plugin.workflow.automjira.client.JiraClient;
import org.squashtest.tm.plugin.workflow.automjira.domain.GetFilenameTestCaseVisitor;
import org.squashtest.tm.plugin.workflow.automjira.domain.SynchronizedField;
import org.squashtest.tm.plugin.workflow.automjira.domain.TestCaseToSynchronize;
import org.squashtest.tm.plugin.workflow.automjira.exception.AutomJiraException;
import org.squashtest.tm.plugin.workflow.automjira.exception.CallbackUrlException;
import org.squashtest.tm.plugin.workflow.automjira.helpers.Util;
import org.squashtest.tm.plugin.workflow.automjira.repository.SynchronisationDao;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationHelperService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationJiraToSquashService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationSquashToJiraService;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.internal.library.PathService;
import org.squashtest.tm.service.internal.repository.AutomatedTestDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import workflowautomjira.com.atlassian.jira.rest.client.api.RestClientException;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;

@Service
@Transactional
public class SynchronizationServiceImpl
implements SynchronizationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizationServiceImpl.class);
    private static final String AUTOM_JIRA_WORKFLOW = "automjira.workflow";
    @Value(value="${logging.file.path}")
    private String logsFolderPath;
    @Inject
    private SynchronizationSquashToJiraService syncSquashToJira;
    @Inject
    private SynchronizationJiraToSquashService syncJiraToSquash;
    @Inject
    private SynchronizationService synchronizationService;
    @Inject
    private SynchronisationDao syncDao;
    @Inject
    private PlatformTransactionManager transactionManager;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private Provider<JiraClient> provider;
    @Inject
    private BugTrackerFinderService serverFinder;
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private CallbackUrlProvider callbackUrlProvider;
    @Value(value="#server.servlet.context-path")
    private String servletContext;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private SynchronizationHelperService synchronizationHelperService;
    @Inject
    private PathService pathService;
    @Inject
    private AutomatedTestDao automatedTestDao;
    private static final String TEST_CASE_PATH_ILLEGAL_PATTERN = "[^a-zA-Z0-9\\_\\-\\/]";

    @Override
    public void performCronAuthentication() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Performing cron internal authentication");
        }
        SecurityContextHolder.clearContext();
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));
        AnonymousAuthenticationToken authentication = new AnonymousAuthenticationToken(AUTOM_JIRA_WORKFLOW, (Object)AUTOM_JIRA_WORKFLOW, authorities);
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication((Authentication)authentication);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - authentication: {}", (Object)context.getAuthentication().isAuthenticated());
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Done cron internal authentication as automjira.workflow");
        }
    }

    @Override
    public void startSynchronization(RemoteSynchronisation remoteSynchronisation) {
        Date newSyncDate = new Date();
        Project project = remoteSynchronisation.getProject();
        SynchronisationStatus finalStatus = SynchronisationStatus.FAILURE;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Begin synchronization for RemoteSynchronisation {} and Server {} ({}) ", new Object[]{remoteSynchronisation.getId(), remoteSynchronisation.getServer().getName(), remoteSynchronisation.getServer().getId()});
        }
        try {
            try {
                this.synchronizationHelperService.logSyncStarted(remoteSynchronisation.getId(), newSyncDate);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[AUTOM-JIRA-SYNC] - Verification of tickets before synchronization id" + remoteSynchronisation.getId());
                }
                List<TestCaseToSynchronize> listTcToCanBeSynchronized = this.findListTestCaseCanBeSynchronized(remoteSynchronisation);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[AUTOM-JIRA-SYNC] - Synchronization Jira to Squash TM");
                }
                this.syncJiraToSquash.synchronizationJiraToSquash(listTcToCanBeSynchronized, remoteSynchronisation);
                this.syncSquashToJira.synchronizationSquashToJira(listTcToCanBeSynchronized, remoteSynchronisation);
                finalStatus = SynchronisationStatus.SUCCESS;
            }
            catch (AutomJiraException e) {
                finalStatus = SynchronisationStatus.FAILURE;
                LOGGER.error("[AUTOM-JIRA-SYNC] - Project id: {} name: {} - Synchronisation id: {} name: {} - Server id: {} name: {} -  Error while processing remoteSynchronisation.", new Object[]{project.getId(), project.getName(), remoteSynchronisation.getId(), remoteSynchronisation.getName(), remoteSynchronisation.getServer().getId(), e});
                this.createLogFile(e, remoteSynchronisation.getId());
                this.synchronizationHelperService.logFinalStatus(remoteSynchronisation.getId(), finalStatus, newSyncDate);
            }
        }
        finally {
            this.synchronizationHelperService.logFinalStatus(remoteSynchronisation.getId(), finalStatus, newSyncDate);
        }
    }

    private void createLogFile(Throwable ex, Long remoteSynchronisationId) {
        File logFolder = new File(this.getPluginLogFolderPath());
        if (!logFolder.exists()) {
            logFolder.mkdirs();
        }
        String logFilePath = this.getSyncErrorLogPath(remoteSynchronisationId);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintWriter pw = new PrintWriter(logFilePath);){
                ex.printStackTrace(pw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error(String.format("Could not generate error log file for synchronisation: (%s)", remoteSynchronisationId), (Throwable)e);
        }
    }

    private String getPluginLogFolderPath() {
        return String.valueOf(this.logsFolderPath) + "/" + "automJira";
    }

    @Override
    public String getSyncErrorLogPath(Long syncId) {
        return String.format("%s/%s-sync-%s-error.log", this.getPluginLogFolderPath(), "automJira", syncId.toString());
    }

    @Override
    public TransactionStatus createTransaction() {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        return this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
    }

    @Override
    public void performFullSynchronization() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[AUTOM-JIRA-SYNC] - Begin full Synchronisation.");
        }
        this.performCronAuthentication();
        try {
            List<Long> listSynchronizationIds = this.syncDao.findSynchronizationIds("henix.plugin.automation.workflow.automjira");
            List<RemoteSynchronisation> listRemoteSynchronization = this.syncDao.getListRemoteSynchronization(listSynchronizationIds);
            listRemoteSynchronization.forEach(this::startSynchronization);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    @Override
    public Issue findRemoteIssueByKey(String remoteIssueKey, BugTracker bugtracker) {
        Issue remoteIssue;
        try (JiraClient jiraClient = (JiraClient)this.provider.get();){
            try {
                jiraClient.jiraClientAuthentication(bugtracker);
                remoteIssue = jiraClient.getIssueJira(remoteIssueKey);
            }
            catch (BugTrackerNoCredentialsException ex) {
                String message = this.i18nHelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", Util.getLocale());
                throw new BugTrackerNoCredentialsException(message, (Throwable)ex);
            }
            catch (RestClientException restClientException) {
                String message = this.i18nHelper.internationalize("workflow.automation.jira.ticket.not-exist", Util.getLocale());
                remoteIssue = null;
                LOGGER.error("[AUTOM-JIRA-SYNC] - Server id: {} name: {} - " + message + ": " + remoteIssueKey, (Object)bugtracker.getId(), (Object)bugtracker.getName());
                if (jiraClient != null) {
                    jiraClient.close();
                }
            }
        }
        return remoteIssue;
    }

    @Override
    public List<TestCaseToSynchronize> findListTestCaseCanBeSynchronized(RemoteSynchronisation remoteSynchronisation) {
        List<TestCaseToSynchronize> listTestCaseToSynchronize = null;
        try (JiraClient jiraClient = (JiraClient)this.provider.get();){
            try {
                Long serverId = remoteSynchronisation.getServer().getId();
                BugTracker bugtracker = this.serverFinder.findById(serverId.longValue());
                jiraClient.jiraClientAuthentication(bugtracker);
                List<Issue> listIssueKeyJira = jiraClient.listIssuesUpdateOnJira(remoteSynchronisation);
                List<RemoteAutomationRequestExtender> listRareByProjectId = this.syncDao.findListRareByProjectId(remoteSynchronisation.getProject().getId());
                listTestCaseToSynchronize = this.synchronizationHelperService.getListTestCaseCanBeSynchronized(listIssueKeyJira, listRareByProjectId);
            }
            catch (NoSuchElementException | BugTrackerNoCredentialsException ex) {
                String message = this.i18nHelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", Util.getLocale());
                LOGGER.error(message);
                throw new AutomJiraException(message, ex);
            }
        }
        return listTestCaseToSynchronize;
    }

    @Override
    public String buildIssueDescription(TestCase testCase) {
        String newLine = "\\\\";
        Locale defaultLocale = Locale.getDefault();
        String id = this.i18nHelper.internationalize("workflow.automation.jira.id.test.case", defaultLocale);
        String uuid = this.i18nHelper.internationalize("workflow.automation.jira.uuid.test.case", defaultLocale);
        String url = this.i18nHelper.internationalize("workflow.automation.jira.url.test.case", defaultLocale);
        String pathSharingServer = this.i18nHelper.internationalize("workflow.automation.jira.chemin.sharing.server", defaultLocale);
        String pathScriptTa = this.i18nHelper.internationalize("workflow.automation.jira.chemin.script.ta", defaultLocale);
        String priorite = this.i18nHelper.internationalize("workflow.automation.jira.priorite", defaultLocale);
        String responsable = this.i18nHelper.internationalize("workflow.automation.jira.responsable", defaultLocale);
        User transmidedBy = testCase.getAutomationRequest().getTransmittedBy();
        String user = transmidedBy.getLogin();
        StringBuilder builder = new StringBuilder();
        builder.append(id).append(" ").append(testCase.getId());
        builder.append(newLine);
        builder.append(uuid).append(" ").append(testCase.getUuid());
        builder.append(newLine);
        builder.append(url).append(" ").append(String.valueOf(this.getUrlToTestCase(testCase)) + " ");
        builder.append(newLine);
        GetKindTestCaseVisitor kindVisitor = new GetKindTestCaseVisitor();
        testCase.accept((TestCaseVisitor)kindVisitor);
        if (!TestCaseKind.STANDARD.equals((Object)kindVisitor.getKind())) {
            String pathCompletSharingServer = null;
            if (testCase.getProject().getScmRepository() != null) {
                pathCompletSharingServer = this.getFullPathSharingServer(testCase);
            }
            builder.append(pathSharingServer).append(" ").append(pathCompletSharingServer != null ? pathCompletSharingServer : "N/A");
            builder.append(newLine);
        } else {
            List automatedTests = this.automatedTestDao.findByTestCases(Collections.singletonList(testCase.getId()));
            AutomatedTest automatedTest = automatedTests.isEmpty() ? null : (AutomatedTest)automatedTests.get(0);
            String pathScript = this.synchronizationService.getPathScriptTA(automatedTest);
            builder.append(pathScriptTa).append(" ").append(pathScript);
            builder.append(newLine);
        }
        builder.append(priorite).append(" ").append(this.synchronizationService.getTestCasePriority(testCase));
        builder.append(newLine);
        builder.append(responsable).append(" ").append(user != null ? user : "N/A");
        builder.append(newLine);
        return builder.toString();
    }

    @Override
    public String buildIssueSummary(TestCase testCase) {
        StringBuilder builder = new StringBuilder();
        if (!StringUtils.isBlank((String)testCase.getReference())) {
            builder.append(testCase.getReference()).append(" - ");
        }
        builder.append(testCase.getName());
        return builder.toString();
    }

    @Override
    public String getUrlToTestCase(TestCase testCase) {
        String url;
        String contextPath;
        try {
            contextPath = this.callbackUrlProvider.getCallbackUrl().toString();
        }
        catch (Exception exception) {
            throw new CallbackUrlException();
        }
        if (contextPath != null) {
            UriComponents uri = ServletUriComponentsBuilder.fromHttpUrl((String)contextPath).path("/test-case-workspace/test-case/{tcId}").buildAndExpand(new Object[]{testCase.getId()});
            url = uri.toString();
        } else {
            UriComponents uri = ServletUriComponentsBuilder.fromPath((String)this.servletContext).path("/test-case-workspace/test-case/{tcId}").buildAndExpand(new Object[]{testCase.getId()});
            url = uri.toString();
        }
        return url;
    }

    @Override
    public String getFullPathSharingServer(TestCase testCase) {
        Project project = (Project)this.projectDao.getReferenceById((Object)testCase.getProject().getId());
        StringBuilder builder = new StringBuilder();
        String treeStructure = "";
        String fullPath = "";
        GetFilenameTestCaseVisitor filenameVisitor = new GetFilenameTestCaseVisitor();
        testCase.accept((TestCaseVisitor)filenameVisitor);
        String pathSharingServer = filenameVisitor.getFileName();
        ScmRepository scmRepo = project.getScmRepository();
        if (scmRepo != null) {
            if (testCase.getProject().isUseTreeStructureInScmRepo()) {
                treeStructure = this.getFoldersPath(testCase);
            }
            fullPath = builder.append(scmRepo.getScmServer().getUrl()).append("/").append(scmRepo.getName()).append("/blob/").append(scmRepo.getWorkingBranch()).append("/").append(scmRepo.getWorkingFolderPath()).append("/").append(treeStructure).append(pathSharingServer).append(" ").toString();
        }
        return fullPath;
    }

    @Override
    public String getPathScriptTA(AutomatedTest automatedTest) {
        return automatedTest != null ? automatedTest.getFullLabel() : "N/A";
    }

    @Override
    public String getTestCasePriority(TestCase testCase) {
        return testCase.getAutomationRequest().getAutomationPriority() != null ? String.valueOf(testCase.getAutomationRequest().getAutomationPriority()) : "N/A";
    }

    @Override
    public String getValueSentForSync(TestCase testCase) throws JsonProcessingException {
        String urlTestCase = this.synchronizationService.getUrlToTestCase(testCase);
        GetKindTestCaseVisitor kindVisitor = new GetKindTestCaseVisitor();
        testCase.accept((TestCaseVisitor)kindVisitor);
        String pathCompletSharingServer = TestCaseKind.STANDARD.equals((Object)kindVisitor.getKind()) ? "" : this.synchronizationService.getFullPathSharingServer(testCase);
        String scriptTA = testCase.getAutomatedTest() != null ? testCase.getAutomatedTest().getFullLabel() : "N/A";
        String priorite = String.valueOf(testCase.getAutomationRequest().getAutomationPriority());
        SynchronizedField synchronizedField = new SynchronizedField(testCase.getReference(), testCase.getName(), urlTestCase, pathCompletSharingServer, scriptTA, priorite);
        return new ObjectMapper().writeValueAsString((Object)synchronizedField);
    }

    private String getFoldersPath(TestCase testCase) {
        if (!testCase.getProject().isUseTreeStructureInScmRepo()) {
            return "";
        }
        String testCaseFoldersPath = this.pathService.buildTestCaseFoldersPath(testCase.getId().longValue());
        if (testCaseFoldersPath != null) {
            return String.valueOf(this.normalizeFilePath(testCaseFoldersPath)) + "/";
        }
        return "";
    }

    private String normalizeFilePath(String path) {
        return org.apache.commons.lang3.StringUtils.stripAccents((String)path).replaceAll(TEST_CASE_PATH_ILLEGAL_PATTERN, "_");
    }
}

