/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.workflow.automjira.domain.CustomFieldInfo;
import org.squashtest.tm.plugin.workflow.automjira.exception.AutomJiraException;
import org.squashtest.tm.plugin.workflow.automjira.helpers.ConvertValue;
import org.squashtest.tm.plugin.workflow.automjira.service.JiraClientService;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.CimIssueType;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.FieldSchema;
import workflowautomjira.org.codehaus.jettison.json.JSONException;

@Service
public class JiraClientServiceImpl
implements JiraClientService {
    @Inject
    private ConvertValue convertValue;
    private static final String SUMMARY = "summary";
    private static final String DESCRIPTION = "description";
    private static final String ISSUE_TYPE = "issuetype";
    private static final String PROJECT = "project";
    private static final String REPORTER = "reporter";
    private static final String ISSUE_LINKS = "issuelinks";

    @Override
    public Map<String, CimFieldInfo> getIssueTypeWithAllFields(Iterable<CimIssueType> listCimIssueType) {
        List listMap = StreamSupport.stream(listCimIssueType.spliterator(), false).map(CimIssueType::getFields).collect(Collectors.toList());
        return listMap.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, CimFieldInfo> getIssueTypeWithMandatoryCufs(Map<String, CimFieldInfo> issueTypeWithAllFields) {
        return issueTypeWithAllFields.entrySet().stream().filter(x -> this.filtreField((String)x.getKey()) && ((CimFieldInfo)x.getValue()).isRequired()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public List<CustomFieldInfo> getListCufInfo(List<CimFieldInfo> mapIssueTypeWithMandatoryCuf) {
        ArrayList<CustomFieldInfo> listInfoCuf = new ArrayList<CustomFieldInfo>();
        mapIssueTypeWithMandatoryCuf.forEach(cimFieldInfo -> {
            CustomFieldInfo cufInfo;
            try {
                cufInfo = this.createNewCustomFieldInfo((CimFieldInfo)cimFieldInfo);
            }
            catch (JSONException e) {
                String message = "[AUTOM-JIRA-SYNC] - Error Allowed values";
                throw new AutomJiraException(message, e);
            }
            listInfoCuf.add(cufInfo);
        });
        return listInfoCuf;
    }

    @Override
    public List<Object> getNewListAllowedValues(String itemType, Iterable<Object> allowedValues) throws JSONException {
        List newList = null;
        for (Object aValue : allowedValues) {
            FieldValue newValue = this.convertValue.createFieldValue(itemType, aValue);
            newList.add(newValue);
        }
        return newList;
    }

    @Override
    public CustomFieldInfo createNewCustomFieldInfo(CimFieldInfo cimFieldInfo) throws JSONException {
        ArrayList<FieldValue> listAllowedValues = new ArrayList<FieldValue>();
        FieldSchema itemSchema = cimFieldInfo.getSchema();
        CustomFieldInfo newCufInfo = new CustomFieldInfo(this.getFieldId(cimFieldInfo.getSchema()), cimFieldInfo.getName(), this.getInputType(itemSchema), "");
        if (cimFieldInfo.getAllowedValues() != null) {
            String itemType = itemSchema.getItems() != null ? itemSchema.getItems() : itemSchema.getType();
            for (Object aValue : cimFieldInfo.getAllowedValues()) {
                FieldValue newValue = this.convertValue.createFieldValue(itemType, aValue);
                listAllowedValues.add(newValue);
            }
            newCufInfo.setAllowedValues(listAllowedValues);
        }
        return newCufInfo;
    }

    @Override
    public List<CimFieldInfo> getRequiredCimFieldInfos(List<CimFieldInfo> cimFieldInfos) {
        return cimFieldInfos.stream().filter(CimFieldInfo::isRequired).filter(it -> this.filtreField(it.getSchema().getSystem())).collect(Collectors.toList());
    }

    private String getFieldId(FieldSchema schema) {
        return schema.getSystem() != null ? schema.getSystem() : "customfield_" + schema.getCustomId();
    }

    private boolean filtreField(String field) {
        return !SUMMARY.equalsIgnoreCase(field) && !DESCRIPTION.equalsIgnoreCase(field) && !ISSUE_LINKS.equalsIgnoreCase(field) && !ISSUE_TYPE.equalsIgnoreCase(field) && !PROJECT.equalsIgnoreCase(field) && !REPORTER.equalsIgnoreCase(field);
    }

    private String getInputType(FieldSchema itemSchema) {
        String type;
        block67: {
            type = null;
            String custom = itemSchema.getCustom();
            String typeJira = custom != null ? custom.split(":")[1] : itemSchema.getType();
            if ("labels".equalsIgnoreCase(itemSchema.getSystem())) {
                typeJira = "labels";
            }
            if ("parent".equalsIgnoreCase(itemSchema.getSystem())) {
                typeJira = "parent";
            }
            if (typeJira == null) break block67;
            switch (typeJira) {
                case "radiobuttons": {
                    type = "option";
                    break;
                }
                case "priority": 
                case "select": 
                case "issuelink": {
                    type = "select";
                    break;
                }
                case "url": {
                    type = "url";
                    break;
                }
                case "textfield": 
                case "parent": 
                case "string": 
                case "gh-epic-label": 
                case "user": {
                    type = "text";
                    break;
                }
                case "float": {
                    type = "number";
                    break;
                }
                case "datetime": {
                    type = "datetime";
                    break;
                }
                case "date": 
                case "datepicker": {
                    type = "date";
                    break;
                }
                case "multicheckboxes": {
                    type = "checkbox";
                    break;
                }
                case "textarea": {
                    type = "textarea";
                    break;
                }
                case "labels": {
                    type = "labels";
                    break;
                }
                case "array": 
                case "multiselect": {
                    type = "multiselect";
                    break;
                }
                case "cascadingselect": {
                    type = "cascadingselect";
                    break;
                }
                case "version": {
                    type = "version";
                    break;
                }
                case "project": {
                    type = PROJECT;
                    break;
                }
                case "multiversion": {
                    type = "multiversion";
                }
            }
        }
        return type;
    }
}

