/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.validators;

import java.util.ArrayList;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.plugin.rest.admin.jackson.model.MilestoneDto;
import org.squashtest.tm.plugin.rest.admin.validators.HelpValidator;
import org.squashtest.tm.plugin.rest.controller.helper.ErrorHandlerHelper;
import org.squashtest.tm.service.internal.repository.MilestoneDao;

@Component
public class MilestoneValidator
implements Validator {
    @Inject
    private MilestoneDao milestoneDao;
    @Inject
    private HelpValidator helpValidator;
    private static final String PATCH_MILESTONE = "patch-milestone";
    private static final String POST_MILESTONE = "post-milestone";

    public boolean supports(Class<?> aClass) {
        return MilestoneDto.class.equals(aClass);
    }

    public void validate(Object target, Errors errors) {
    }

    public void milestonePatchValidator(Long milestoneId, MilestoneDto milestoneDto) throws BindException {
        ArrayList<BeanPropertyBindingResult> errors = new ArrayList<BeanPropertyBindingResult>();
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)milestoneDto, PATCH_MILESTONE);
        this.validate(milestoneDto, (Errors)validation);
        if (this.milestoneDao.getReferenceById((Object)milestoneId) == null) {
            String message = String.format("No entity known for type Milestone and id %d", milestoneId);
            validation.rejectValue("id", "invalid id", message);
        }
        if (milestoneDto.isHasLabel()) {
            this.helpValidator.validateAttributes(milestoneDto.getLabel(), (Errors)validation);
            Milestone milestone = this.milestoneDao.findByLabel(milestoneDto.getLabel());
            if (milestone != null && milestoneDto.getLabel() != null && milestone.getLabel().equals(milestoneDto.getLabel())) {
                validation.rejectValue("label", "invalid value", "A milestone with the same label already exists in the database");
            }
        }
        if (validation.hasErrors()) {
            errors.add(validation);
        }
        ErrorHandlerHelper.throwIfError((Object)milestoneDto, errors, (String)PATCH_MILESTONE);
    }
}

