/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import java.util.List;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ScmServerDto;
import org.squashtest.tm.plugin.rest.admin.service.RestScmServerService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.ScmServerPatcher;
import org.squashtest.tm.plugin.rest.core.utils.ExceptionUtils;
import org.squashtest.tm.service.internal.repository.ScmServerDao;
import org.squashtest.tm.service.scmserver.ScmServerManagerService;

@Service
@Transactional
public class RestScmServerServiceImpl
implements RestScmServerService {
    @Inject
    private ScmServerManagerService scmServerManagerService;
    @Inject
    private ScmServerDao scmServerDao;
    @Inject
    private ScmServerPatcher scmServerPatcher;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ScmServer findScmServerById(Long scmServerId) {
        return (ScmServer)this.scmServerDao.findById((Object)scmServerId).orElseThrow(() -> ExceptionUtils.entityNotFoundException(ScmServer.class, (Long)scmServerId));
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ScmServer addScmServer(ScmServerDto scmServerDto) {
        ScmServer newScmServer = new ScmServer();
        this.scmServerPatcher.patch(newScmServer, scmServerDto);
        newScmServer.setAuthenticationPolicy(AuthenticationPolicy.APP_LEVEL);
        return (ScmServer)this.scmServerDao.save((Object)newScmServer);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ScmServer updateScmServer(Long scmServerId, ScmServerDto scmServerDto) {
        ScmServer scmServer = (ScmServer)this.scmServerDao.getReferenceById((Object)scmServerId);
        this.scmServerPatcher.patch(scmServer, scmServerDto);
        return scmServer;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteScmServer(List<Long> scmServerIds) {
        this.scmServerManagerService.deleteScmServers(scmServerIds);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<ScmServer> getAllScmServer(Pageable pageable) {
        return this.scmServerDao.findAll(pageable);
    }
}

